<?php
    $app_local   = get_default_language_code();
?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Account
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<div class="account-section">
    <div class="account-bg"></div>
    <div class="account-area change-form">
        <div class="account-close"></div>
        <div class="account-form-area">
            <div class="account-logo text-start">
                <a href="<?php echo e(setRoute('index')); ?>" class="site-logo">
                    <img src="<?php echo e(get_logo($basic_settings)); ?>" alt="logo">
                </a>
            </div>
            <h5 class="title"><?php echo e(@$login->value->language->$app_local->title ?? ''); ?></h5>
            <p><?php echo e(@$login->value->language->$app_local->description ?? ''); ?></p>
            <form action="<?php echo e(setRoute('user.login.submit')); ?>" class="account-form" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-lg-12 form-group">
                        <input type="email" required class="form-control form--control" name="credentials" placeholder="<?php echo e(__("Email")); ?>" spellcheck="false" data-ms-editor="true">
                    </div>
                    <div class="col-lg-12 form-group" id="show_hide_password">
                        <input type="password" required class="form-control form--control" name="password" placeholder="<?php echo e(__("Password")); ?>">
                        <a href="" class="show-pass"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                    </div>
                    <div class="col-lg-12 form-group">
                        <div class="forgot-item">
                            <label><a href="<?php echo e(setRoute('user.password.forgot')); ?>"><?php echo e(__("Forgot Password")); ?>?</a></label>
                        </div>
                    </div>
                    <div class="col-lg-12 form-group text-center">
                        <button type="submit" class="btn--base w-100"><?php echo e(__("Login Now")); ?></button>
                    </div>
                    <div class="col-lg-12 text-center">
                        <div class="account-item">
                            <label><?php echo e(__("Don't Have An Account")); ?>? <a href="#0" class="account-control-btn"><?php echo e(__("Register Now")); ?></a></label>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="account-area">
        <div class="account-close"></div>
        <div class="account-form-area">
            <div class="account-logo text-start">
                <a class="site-logo" href="<?php echo e(setRoute('index')); ?>"><img src="<?php echo e(get_logo($basic_settings)); ?> " alt="logo"></a>
            </div>
            <h5 class="title"><?php echo e(@$register->value->language->$app_local->title ?? ''); ?></h5>
            <p><?php echo e(@$login->value->language->$app_local->description ?? ''); ?></p>
            <form action="<?php echo e(setRoute('user.register.submit')); ?>" method="POST" class="account-form">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-lg-6 form-group">
                        <input type="text" class="form-control form--control" name="firstname" placeholder="<?php echo e(__("First Name")); ?>" spellcheck="false" data-ms-editor="true">
                    </div>
                    <div class="col-lg-6 form-group">
                        <input type="text" class="form-control form--control" name="lastname" placeholder="<?php echo e(__("Last Name")); ?>" spellcheck="false" data-ms-editor="true">
                    </div>
                    <div class="col-lg-12 form-group">
                        <input type="email" class="form-control form--control" name="email" placeholder="<?php echo e(__("Email")); ?>">
                    </div>
                    <div class="col-lg-12 form-group" id="show_hide_password">
                        <input type="password" class="form-control form--control" name="password" placeholder="<?php echo e(__("Password")); ?>">
                        <a href="" class="show-pass"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                    </div>
                    <div class="col-lg-12 form-group">
                        <div class="custom-check-group">
                            <input type="checkbox" name="agree" id="level-1">
                            <?php
                                $data   = App\Models\Admin\UsefulLink::where('type',global_const()::USEFUL_LINK_PRIVACY_POLICY)->first();
                            ?>
                            <label for="level-1"><?php echo e(__("I have agreed with")); ?><a href="<?php echo e(setRoute('link',$data->slug)); ?>" class="text--base"><?php echo e(__("Terms Of Use")); ?> &amp; <?php echo e(__("Privacy Policy")); ?></a></label>
                        </div>
                    </div>
                    <div class="col-lg-12 form-group text-center">
                        <button type="submit" class="btn--base w-100"><?php echo e(__("Register Now")); ?></button>
                    </div>
                    <div class="col-lg-12 text-center">
                        <div class="account-item">
                            <label><?php echo e(__("Already Have An Account?")); ?> <a href="#0" class="account-control-btn"><?php echo e(__("Login Now")); ?></a></label>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Account
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->


<?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/modals/auth/login-register.blade.php ENDPATH**/ ?>