

<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('User Care'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card mt-15">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("User Overview")); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form">
                <div class="row align-items-center mb-10-none">
                    <div class="col-xl-4 col-lg-4 form-group">
                        <div class="user-action-btn-area">
                            
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.link.custom',[
                                    'href'          => setRoute('admin.users.login.logs',$user->username),
                                    'class'         => "bg--base two",
                                    'icon'          => "las la-sign-in-alt me-1",
                                    'text'          => __("Login Logs"),
                                    'permission'    => "admin.users.login.logs",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.link.custom',[
                                    'href'          => "#email-send",
                                    'class'         => "bg--base three modal-btn",
                                    'icon'          => "las la-mail-bulk me-1",
                                    'text'          => __("Send Email"),
                                    'permission'    => "admin.users.send.mail",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.link.custom',[
                                    'class'         => "bg--base four login-as-member",
                                    'icon'          => "las la-user-check me-1",
                                    'text'          => __("Login as Member"),
                                    'permission'    => "admin.users.login.as.member",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.link.custom',[
                                    'href'          => setRoute('admin.users.mail.logs',$user->username),
                                    'class'         => "bg--base five",
                                    'icon'          => "las la-history me-1",
                                    'text'          => __("Email Logs"),
                                    'permission'    => "admin.users.mail.logs",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 form-group">
                        <div class="user-profile-thumb">
                            <img src="<?php echo e($user->userImage); ?>" alt="user">
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 form-group">
                        <ul class="user-profile-list">
                            <li class="bg--base one"><?php echo e(__("Full Name")); ?>: <span><?php echo e($user->fullname); ?></span></li>
                            <li class="bg--info two"><?php echo e(__("Username")); ?>: <span><?php echo e("@".$user->username); ?></span></li>
                            <li class="bg--success three"><?php echo e(__("Email")); ?>: <span><?php echo e($user->email); ?></span></li>
                            <li class="bg--warning four"><?php echo e(__("Status")); ?>: <span><?php echo e($user->stringStatus->value); ?></span></li>
                            <li class="bg--danger five"><?php echo e(__("Last Login")); ?>: <span><?php echo e($user->lastLogin); ?></span></li>
                        </ul>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="custom-card mt-15">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("Information of User")); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form" method="POST" action="<?php echo e(setRoute('admin.users.details.update',$user->username)); ?>">
                <?php echo csrf_field(); ?>
                <div class="row mb-10-none">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'label'         => __("First Name")."*",
                            'name'          => "firstname",
                            'value'         => old("firstname",$user->firstname),
                            'attribute'     => "required",
                            'placeholder'   => __("Write Here")."...",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'label'         => __("Last Name")."*",
                            'name'          => "lastname",
                            'value'         => old("lastname",$user->lastname),
                            'attribute'     => "required",
                            'placeholder'   => __("Write Here")."...",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__("Country")); ?></label>
                        <select name="country" class="form--control select2-auto-tokenize country-select" data-placeholder="Select Country" data-old="<?php echo e(old('country',$user->address->country ?? "")); ?>"></select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__("Phone Number")); ?></label>
                        <div class="input-group">
                            <input type="text" class="form--control" placeholder=<?php echo e(__("Write Here")); ?> name="mobile" value="<?php echo e(old('mobile',$user->full_mobile)); ?>">
                        </div>
                        <?php $__errorArgs = ["mobile"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback d-block" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php
                            $old_state = old('state',$user->address->state ?? "");
                        ?>
                        <label><?php echo e(__("State")); ?></label>
                        <select name="state" class="form--control select2-auto-tokenize state-select" data-placeholder="Select State" data-old="<?php echo e($old_state); ?>">
                            <?php if($old_state): ?>
                                <option value="<?php echo e($old_state); ?>" selected><?php echo e($old_state); ?></option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php
                            $old_city = old('city',$user->address->city ?? "");
                        ?>
                        <label><?php echo e(__("City")); ?></label>
                        <select name="city" class="form--control select2-auto-tokenize city-select" data-placeholder="Select City" data-old="<?php echo e($old_city); ?>">
                            <?php if($old_city): ?>
                                <option value="<?php echo e($old_city); ?>" selected><?php echo e($old_city); ?></option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'label'         => __("Zip Code"),
                            'name'          => "zip_code",
                            'placeholder'   => __("Write Here")."...",
                            'value'         => old('zip_code',$user->address->zip ?? "")
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'label'         => __("Address"),
                            'name'          => 'address',
                            'value'         => old("address",$user->address->address ?? ""),
                            'placeholder'   => __("Write Here")."...",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                        <?php echo $__env->make('admin.components.form.switcher', [
                            'label'         => __("User Status"),
                            'value'         => old('status',$user->status),
                            'name'          => "status",
                            'options'       => [__("Active") => 1, __("Banned") => 0],
                            'permission'    => "admin.users.details.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                        <?php echo $__env->make('admin.components.form.switcher', [
                            'label'         => __("Email Verification"),
                            'value'         => old('email_verified',$user->email_verified),
                            'name'          => "email_verified",
                            'options'       => [__("Verified") => 1, __("Unverified") => 0],
                            'permission'    => "admin.users.details.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    
                    <div class="col-xl-12 col-lg-12 form-group mt-4">
                        <?php echo $__env->make('admin.components.button.form-btn',[
                            'text'          => "Update",
                            'permission'    => "admin.users.details.update",
                            'class'         => "w-100 btn-loading",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
    <?php echo $__env->make('admin.components.modals.send-mail-user',compact("user"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        getAllCountries("<?php echo e(setRoute('global.countries')); ?>");
        $(document).ready(function() {

            openModalWhenError("email-send","#email-send");
            
            $("select[name=country]").change(function(){
                var phoneCode = $("select[name=country] :selected").attr("data-mobile-code");
                placePhoneCode(phoneCode);
            });

            setTimeout(() => {
                var phoneCodeOnload = $("select[name=country] :selected").attr("data-mobile-code");
                placePhoneCode(phoneCodeOnload);
            }, 400);

            countrySelect(".country-select",$(".country-select").siblings(".select2"));
            stateSelect(".state-select",$(".state-select").siblings(".select2"));


            $(".login-as-member").click(function() {
                var action  = "<?php echo e(setRoute('admin.users.login.as.member',$user->username)); ?>";
                var target  = "<?php echo e($user->username); ?>";
                postFormAndSubmit(action,target);
            });
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/admin/sections/user-care/details.blade.php ENDPATH**/ ?>