<?php if(admin_permission_by_name("admin.health.package.store")): ?>
    <div id="add-health-package" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header px-0">
                <h5 class="modal-title"><?php echo e(__("Add Health Package")); ?></h5>
            </div>
            <div class="modal-form-data">
                <form class="card-form" action="<?php echo e(setRoute('admin.health.package.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row mb-10-none">
                        <div class="col-xl-12 col-lg-12 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'             => __("Package Name")."*",
                                'name'              => "name",
                                'placeholder'       => __("Write Name")."...",
                                'value'             => old('name'),  
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'             => __("Package Title"),
                                'name'              => "title",
                                'placeholder'       => __("Write Title")."...",
                                'value'             => old('title'),  
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group">
                            <label><?php echo e(__("Regular Price")); ?>*</label>
                            <div class="input-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                'name'              => "price",
                                'class'             => "number-input",
                                'placeholder'       => __("Write Price")."...",
                                'value'             => old('price'),   
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                            </div>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group">
                            <label><?php echo e(__("Offer Price")); ?></label>
                            <div class="input-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                'name'              => "offer_price",
                                'class'             => "number-input",
                                'placeholder'       => __("Write Offer Price")."...",
                                'value'             => old('offer_price'),   
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                            </div>
                        </div>
                        
                        <div class="col-xl-12 col-lg-12 form-group">
                            <?php echo $__env->make('admin.components.button.form-btn',[
                                'class'         => "w-100 btn-loading",
                                'text'          => "Submit",
                                'permission'    => "admin.health.package.store"
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/admin/components/modals/health-package/add.blade.php ENDPATH**/ ?>