

<?php $__env->startSection('content'); ?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Booking section  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="booking-section ptb-120">
    <div class="container">
        <form class="booking-form" action="<?php echo e(setRoute('frontend.home.service.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
        <div class="row mb-30-none">
            
                <div class="col-lg-5 mb-30">
                    <div class="booking-area">
                        <div class="title-area text-center mb-30">
                            <h4 class="title"><?php echo e(__("SERVICE")); ?> <span class="text--base"><?php echo e(__("AT YOUR DOORSTEP")); ?></span></h4>
                            <p><?php echo e(__("No more waiting rooms, no more long commutes, and no more hassle. With our service, you can now book a doctor appointment and have a qualified healthcare professional visit you at your preferred location and time")); ?>.</p>
                        </div>
                        <div class="content pt-0">
                            <div class="list-wrapper">
                                <ul class="list">
                                    <li><?php echo e(__("Address")); ?>:<span class="text--base"><?php echo e($contact->value->address ?? ""); ?></span></li>
                                    <li><?php echo e(__("Contact")); ?>:<span class="text--base text-lowercase"><?php echo e($contact->value->email ?? ""); ?></span></li>
                                </ul>
                            </div>
                            <div class="list-wrapper pt-20">
                                <h4 class="title text--base"><i class="fas fa-history"></i> <?php echo e(__("Schedule")); ?></h4>
                                <div class="shedule-option pt-10">
                                    <?php $__currentLoopData = $dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="shedule-item">
                                            <div class="shedule-inner">
                                                <input type="radio" name="schedule" value="<?php echo e($date['day'].','.$date['date'].' '.$date['Month'].' '.$date['Year']); ?>" class="hide-input" id="shedule_<?php echo e($key); ?>">
                                                <label for="shedule_<?php echo e($key); ?>" class="package--amount">
                                                    <strong><?php echo e($date['day']); ?> <?php echo e($date['date']); ?>th</strong>
                                                    <sup><?php echo e($date['month']); ?> <?php echo e($date['year']); ?></sup>
                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 mb-30">
                    <div class="booking-area fixed">
                        
                            <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i><?php echo e(__("Appointment Form")); ?></h3>
                            <div class="row justify-content-center mb-20-none">
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Patient Name").'<span class="text--base">*</span>',
                                        'name'         => 'name',
                                        'placeholder'  => __("Enter Name").'...',
                                        'value'        => old('name'),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Mobile").'<span class="text--warning">'.'('.__("Optional").')'.'</span>',
                                        'name'         => 'phone',
                                        'placeholder'  => __("Mobile").'...',
                                        'value'        => old('phone'),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12 form-group">
                                    <label><?php echo e(__("Age")); ?> <span class="text--base">*</span></label>
                                    <?php
                                        $age = old("age_type");
                                    ?>
                                    <div class="input-group">
                                        <input type="number" name="age" class="form--control" value="<?php echo e(old('age')); ?>" min="1" placeholder="<?php echo e(__("Enter your age")); ?>">
                                        <select name="age_type" class="form--control">
                                            <option  selected value="Years" <?php if($age == "Years"): ?> selected <?php endif; ?>><?php echo e(__("Years")); ?></option>
                                            <option value="Months" <?php if($age == "Months"): ?> selected <?php endif; ?>><?php echo e(__("Months")); ?></option>
                                            <option value="Days" <?php if($age == "Days"): ?> selected <?php endif; ?>><?php echo e(__("Days")); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <?php
                                        $gender   = old('gender');
                                    ?>
                                    <label><?php echo e(__("Gender")); ?><span class="text--base">*</span></label>
                                    <select class="form--control" name="gender">
                                        <option selected disabled><?php echo e(__("Select Gender")); ?></option>
                                        <option value="<?php echo e(global_const()::GENDER_MALE); ?>" <?php if($gender== global_const()::GENDER_MALE): ?> selected <?php endif; ?>><?php echo e(global_const()::GENDER_MALE); ?></option>
                                        <option value="<?php echo e(global_const()::GENDER_FEMALE); ?>" <?php if($gender== global_const()::GENDER_FEMALE): ?> selected <?php endif; ?>><?php echo e(global_const()::GENDER_FEMALE); ?></option>
                                        <option value="<?php echo e(global_const()::GENDER_OTHER); ?>" <?php if($gender== global_const()::GENDER_OTHER): ?> selected <?php endif; ?>><?php echo e(global_const()::GENDER_OTHER); ?></option>
                                    </select>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Email").'<span class="text--base">*</span>',
                                        'name'         => 'email',
                                        'placeholder'  => __("Email").'...',
                                        'value'        => old('email'),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Address") .'<span class="text--base">*</span>',
                                        'name'         => 'address',
                                        'placeholder'  => __("Enter Address").'...',
                                        'value'        => old('address'),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12 form-group">
                                    <div class="home-check-area custom-check-group">
                                        <?php $__currentLoopData = $hospital_tests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="home-check-wrapper">
                                                <input type="checkbox" name="type[]" value="<?php echo e($item->name); ?>" id="home_<?php echo e($item->id); ?>">
                                                <label for="home_<?php echo e($item->id); ?>"><?php echo e($item->name ?? ""); ?></label>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <?php echo $__env->make('admin.components.form.textarea',[
                                        'label'         => __("Message").'<span class="text--warning">'.'('.__("Optional").')'.'</span>',
                                        'name'          => 'message',
                                        'placeholder'   => __("Write Here")."...",
                                        'value'        => old('message'),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-lg-12 form-group">
                                    <button type="submit" class="btn--base small"><?php echo e(__("Submit")); ?> <i class="fas fa-paper-plane ms-1"></i></button>
                                </div>
                            </div>
                        
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Booking section  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->


<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/pages/home_service.blade.php ENDPATH**/ ?>