

<?php $__env->startPush('css'); ?>

    <style>
        .fileholder {
            min-height: 374px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,.fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view{
            height: 330px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Investigations")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e(__($page_title)); ?></h5>
                <div class="table-btn-area">
                    <?php echo $__env->make("admin.components.link.add-default",[
                        'text'        => __("Add Investigation"),
                        'href'        => "#add-investigation",
                        "class"       => "modal-btn",
                        'permission'  => "admin.investigation.store"

                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__("Name")); ?></th>
                            <th><?php echo e(__("Price")); ?></th>
                            <th><?php echo e(__("Status")); ?></th>
                            <th><?php echo e(__("Category")); ?></th>
                            <th><?php echo e(__("Last Edit By")); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $investigations ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-item="<?php echo e($item); ?>">
                                <td><?php echo e($item->name); ?></td>
                                <td>
                                    <?php if($item->offer_price): ?>
                                    <span class="price"><?php echo e(get_amount($item->offer_price)  ?? ""); ?> <?php echo e(App\Providers\Admin\CurrencyProvider::default()->code); ?></span>
                                    <del><?php echo e(get_amount($item->price)  ?? ""); ?> <?php echo e(App\Providers\Admin\CurrencyProvider::default()->code); ?></del>
                                    <?php else: ?>
                                    <span><?php echo e(get_amount($item->price)  ?? ""); ?> <?php echo e(App\Providers\Admin\CurrencyProvider::default()->code); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo $__env->make('admin.components.form.switcher',[
                                       'name'        => 'status',
                                       'value'       => $item->status, 
                                       'options'     => [__("Enable") => 1, __("Disable") => 0 ],
                                       'onload'      => true,
                                       'data_target' => $item->id,
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </td>
                                <td>
                                    <?php if($item->home_service == true): ?>
                                        <span class="badge badge--primary"><?php echo e(__("Home Service")); ?></span>
                                      
                                    <?php else: ?>
                                        <span class="badge badge--danger"><?php echo e(__("Investigation")); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($item->admin->full_name); ?></td>
                                <td>
                                    <?php echo $__env->make('admin.components.link.edit-default',[
                                        'class'  => "edit-modal-button",
                                        'permission' => "admin.investigation.update"
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <button class="btn btn--base btn--danger delete-modal-button"><i class="las la-trash-alt"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make("admin.components.alerts.empty",["colspan" =>4], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php echo e(get_paginate($investigations)); ?>

    </div>
    <?php echo $__env->make("admin.components.modals.investigation.add", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make("admin.components.modals.investigation.edit", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        openModalWhenError("add-investigation","#add-investigation");
        $(document).ready(function(){
            switcherAjax("<?php echo e(setRoute('admin.investigation.status.update')); ?>");
        });
        
        $(".delete-modal-button").click(function(){
            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            var actionRoute = "<?php echo e(setRoute('admin.investigation.delete')); ?>";
            var target = oldData.id;
            var message = `Are you sure to <span>delete</span> this test?`;

            openDeleteModal(actionRoute,target,message);
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/admin/sections/investigation/index.blade.php ENDPATH**/ ?>