

<?php $__env->startPush('css'); ?>

    <style>
        .fileholder {
            min-height: 200px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,.fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view{
            height: 330px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ],
        [
            'name'  => __("Doctors"),
            'url'   => setRoute("admin.doctor.care.index")
        ]
    ], 'active' => __("Doctor Create")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="custom-card">
    <div class="card-header">
        <h6 class="title"><?php echo e(__($page_title)); ?></h6>
    </div>
    <div class="card-body">
        <form class="card-form" action="<?php echo e(setRoute('admin.doctor.care.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row justify-content-center">
                <div class="col-xl-4 col-lg-4 form-group mb-5">
                    <?php echo $__env->make('admin.components.form.input-file',[
                        'label'             => __("Image"),
                        'name'              => "image",
                        'class'             => "file-holder",
                        'old_files'         => old("image"),
                        'attribute'         => 'data-height=130'
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="row justify-content-center mb-10-none">
                <div class="col-xl-6 col-lg-6 form-group">
                    <label><?php echo e(__("Select Branch")); ?>*</label>
                    <select class="form--control select2-basic" name="branch">
                        <option disabled selected><?php echo e(__("Select Branch")); ?></option>
                        <?php $__currentLoopData = $hospital_branch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <label><?php echo e(__("Select Department")); ?>*</label>
                    <select class="form--control select2-basic" name="department">
                        <option disabled selected><?php echo e(__("Select Department")); ?></option>
                    </select>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Name")."*",
                        'name'              => "name",
                        'placeholder'       => __("Write Name")."...",
                        'value'             => old("name"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Title")."*",
                        'name'              => "doctor_title",
                        'placeholder'       => __("Write Title")."...",
                        'value'             => old("doctor_title"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Qualification")."*",
                        'name'              => "qualification",
                        'placeholder'       => __("Write Qualification")."...",
                        'value'             => old("qualification"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Speciality"),
                        'name'              => "speciality",
                        'placeholder'       => __("Write Speciality")."...",
                        'value'             => old("speciality"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <label><?php echo e(__("Language Spoken")); ?><span>*</span></label>
                    <select name="language[]" class="form-control select2-auto-tokenize"  multiple="multiple" data-placeholder="Add Language"></select>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Designation")."*",
                        'name'              => "designation",
                        'placeholder'       => __("Write Designation")."...",
                        'value'             => old("designation"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Contact")."*",
                        'name'              => "contact",
                        'placeholder'       => __("Write Contact")."...",
                        'value'             => old("contact"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Off Days")."*",
                        'name'              => "off_days",
                        'placeholder'       => __("Write Off Days")."...",
                        'value'             => old("off_days"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Floor Number"),
                        'name'              => "floor_number",
                        'placeholder'       => __("Write Floor Number")."...",
                        'value'             => old("floor_number"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Room Number"),
                        'name'              => "room_number",
                        'placeholder'       => __("Write Room Number")."...",
                        'value'             => old("room_number"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'             => __("Doctor Address"),
                        'name'              => "address",
                        'placeholder'       => __("Write Address")."...",
                        'value'             => old("address"),   
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-xl-6 col-lg-6 mb-4">
                    <label><?php echo e(__("Doctor Fees")); ?>*</label>
                    <div class="input-group">
                        <?php echo $__env->make('admin.components.form.input',[
                        'name'              => "fees",
                        'class'             => "number-input",
                        'placeholder'       => __("Write Fees")."...",
                        'value'             => old('fees'),   
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                    </div>
                </div>
                
                <div class="col-xl-12 col-lg-12 form-group">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h6 class="title"><?php echo e(__("Schedule")); ?></h6>
                            <button type="button" class="btn--base add-schedule-btn"><i class="fas fa-plus"></i> <?php echo e(__("Add")); ?></button>
                        </div>
                        <div class="card-inner-body">
                            <div class="results">
                                <?php echo $__env->make('admin.components.doctor-care.schedule-item',compact('weeks'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>    
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-12 col-lg-12 form-group">
                    <?php echo $__env->make('admin.components.button.form-btn',[
                        'class'         => "w-100 btn-loading",
                        'text'          => "Submit",
                        'permission'    => "admin.hospital.branch.store"
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>

        $(document).ready(function(){

            var getDepartmentURL = "<?php echo e(setRoute('admin.doctor.care.get.branch.departments')); ?>";

            $('select[name="branch"]').on('change',function(){
                var branch = $(this).val();

                if(branch == "" || branch == null) {
                    return false;
                }

                $.post(getDepartmentURL,{branch:branch,_token:"<?php echo e(csrf_token()); ?>"},function(response){
                    // console.log(response.data.branch.departments);
                    var option = '';
                    if(response.data.branch.departments.length > 0) {
                        $.each(response.data.branch.departments,function(index,item) {
                            option += `<option value="${item.hospital_department_id}">${item.department.name}</option>`
                        });

                        // console.log(option);
                        $("select[name=department]").html(option);
                        $("select[name=department]").select2();

                    }
                }).fail(function(response) {

                    var errorText = response.responseJSON;
                    
                });

            });
        });
        //getScheduleDays
        $(document).ready(function(){

            var getDayURL = "<?php echo e(setRoute('admin.doctor.care.get.days')); ?>";
            $('.add-schedule-btn').click(function(){
                $.get(getDayURL,function(data){
                    $('.results').prepend(data);
                    $('.results').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/admin/sections/doctor-care/create.blade.php ENDPATH**/ ?>