

<?php $__env->startPush('css'); ?>
    <style>
        .package--amount img{
            height: 50px;
            width: 50px;
            border-radius: 50%;
            overflow: hidden;
            margin: 10px;
            object-fit: contain;
            border: 1px solid #e4dfdf;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Booking section  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="booking-section ptb-120">
    <div class="container">
        <div class="row justify-content-center mb-30-none">
            <div class="col-xl-8 col-lg-8 col-md-12 mb-30">
                <div class="booking-area">
                    <form action="<?php echo e(setRoute('frontend.appointment.booking.confirm',$patient->slug)); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="content pt-0">
                            <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i><?php echo e(__("Appointment Preview")); ?></h3>
                            <div class="list-wrapper">
                                <ul class="list">
                                    <li><?php echo e(__("Doctor Name")); ?>:<span><?php echo e($patient->doctors->name ?? ""); ?></span></li>
                                    <li><?php echo e(__("Speciality")); ?>:<span><?php echo e($patient->doctors->speciality ?? ""); ?></span></li>
                                    <li><?php echo e(__("Schedule")); ?>:<span><?php echo e($patient->schedules->week->day ?? ""); ?></span></li>
                                    <li><?php echo e(__("Patient Name")); ?>:<span><?php echo e($patient->name ?? ""); ?></span></li>
                                    <li><?php echo e(__("Mobile")); ?>:<span><?php echo e($patient->phone ?? ""); ?></span></li>
                                    <li><?php echo e(__("Email")); ?>:<span class="text-lowercase"><?php echo e($patient->email ?? ""); ?></span></li>
                                    <li><?php echo e(__("Type")); ?>:<span><?php echo e($patient->type ?? ""); ?></span></li>
                                    <li><?php echo e(__("Gender")); ?>:<span><?php echo e($patient->gender ?? ""); ?></span></li>
                                    <li><?php echo e(__("Doctor Fees")); ?>:<span><?php echo e(get_amount($patient->details->doctor_fees,get_default_currency_code())); ?></span></li>
                                    <li><?php echo e(__("Fees & Charges")); ?>:<span><?php echo e(get_amount($patient->details->total_charge,get_default_currency_code())); ?></span></li>
                                    <li><?php echo e(__("Payable Amount")); ?>:<span><?php echo e(get_amount($patient->details->payable_amount,get_default_currency_code())); ?></span></li>
                                </ul>
                            </div>
                            <div class="payment-type pt-4">
                                <div class="form-group">
                                    <h4 class="title text--base"><i class="fas fa-spinner"></i> <?php echo e(__("Select Payment Method")); ?> *</h4>
                                    <div class="shedule-option pt-10">
                                        <div class="shedule-item">
                                            <div class="shedule-inner">
                                                <input type="radio" id="cashPayment" class="hide-input" value="<?php echo e(global_const()::CASH_PAYMENT); ?>" checked name="selected_payment_method">
                                                <label for="cashPayment" class="package--amount d-flex align-items-center justify-content-center"><img src="<?php echo e(asset("public/frontend/images/cashpay.png")); ?>" alt="icon"><?php echo e(__("Cash Payment")); ?></label>
                                            </div>
                                        </div>
                                        <div class="shedule-item">
                                            <div class="shedule-inner">
                                                <input type="radio" id="onlinePayment" class="hide-input" value="" name="selected_payment_method">
                                                <label for="onlinePayment" class="package--amount d-flex align-items-center justify-content-center"><img src="<?php echo e(asset("public/frontend/images/onlinepay.jpg")); ?>" alt="icon"><?php echo e(__("Online Payment")); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="shedule-option collapse pt-10">
                                        <?php $__currentLoopData = $payment_gateway; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="shedule-item">
                                            <div class="shedule-inner">
                                                <input type="radio" id="level_<?php echo e($item->id); ?>" class="hide-input" name="payment_method" value="<?php echo e($item->alias); ?>">
                                                <label for="level_<?php echo e($item->id); ?>" class="package--amount d-flex align-items-center justify-content-center"><img src="<?php echo e(get_image($item->image ,'payment-gateways')); ?>" alt="icon"><?php echo e(__($item->gateway->name)); ?></label>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="btn-area mt-20">
                                <?php if($patient->status == 1 ): ?>
                                    <button disabled class="btn--base small w-100"><?php echo e(__("Already Confirmed")); ?><i class="fas fa-check-circle ms-1"></i></button>
                                <?php else: ?>
                                    <button type="submit" class="btn--base small w-100" ><?php echo e(__("Confirm Appointment")); ?><i class="fas fa-check-circle ms-1"></i></button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Booking section  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
        var onlinePaymentRadio = document.getElementById('onlinePayment');
        var cashPaymentRadio = document.getElementById('cashPayment');
        var collapseElement = document.querySelector('.shedule-option.collapse');

        onlinePaymentRadio.addEventListener('change', function() {
            if (this.checked) {
                collapseElement.style.display = 'flex';
            }
        });

        cashPaymentRadio.addEventListener('change', function() {
            if (this.checked) {
                collapseElement.style.display = 'none';
            }
        });
    });
    
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/pages/appointment-booking-preview.blade.php ENDPATH**/ ?>