<?php if(admin_permission_by_name("admin.admins.admin.store")): ?>
    <div id="admin-add" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__("Add Admin")); ?></h5>
            </div>
            <div class="modal-form-data">
                <form class="modal-form" method="POST" action="<?php echo e(setRoute('admin.admins.admin.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row mb-10-none">
                        <div class="col-xl-12 col-lg-12 form-group">
                            <label for="countryFlag"><?php echo e(__("Admin Profile Image")); ?></label>
                            <div class="col-12 col-sm-3 m-auto">
                                <?php echo $__env->make('admin.components.form.input-file',[
                                    'label'         => false,
                                    'class'         => "file-holder m-auto",
                                    'name'          => "image",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>

                        <div class="col-xl-6 col-lg-6 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __("First Name")."*",
                                'name'          => "firstname",
                                'placeholder'   => __("First Name"),
                                'value'         => old("firstname"),  
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __("Last Name")."*",
                                'name'          => "lastname",
                                'placeholder'   => __("Last Name"),
                                'value'         => old("lastname"),   
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __("Username")."*",
                                'name'          => "username",
                                'placeholder'   => __("Username"),
                                'value'         => old("username"),       
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __("Email")."*",
                                'name'          => "email",
                                'placeholder'   => __("Email"),
                                'value'         => old("email"),     
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group">
                            <label><?php echo e(__("Password")); ?>*</label>
                            <div class="input-group">
                                <input type="text" class="form--control place_random_password <?php $__errorArgs = ["password"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__("Password")); ?>" name="password">
                                <button class="input-group-text rand_password_generator" type="button"><?php echo e(__("Generate")); ?></button>
                            </div>
                            <?php $__errorArgs = ["password"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __("Phone")."*",
                                'name'          => "phone",
                                'placeholder'   => __("Phone"),
                                'value'         => old("phone"),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            <label><?php echo e(__("Role")); ?>*</label>
                            <select class="form--control nice-select" name="role" data-old="<?php echo e(old("role")); ?>">
                                <option selected disabled><?php echo e(__("Select Role")); ?></option>
                                <?php $__currentLoopData = $admin_roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                            <button type="button" class="btn btn--danger modal-close"><?php echo e(__("Cancel")); ?></button>
                            <button type="submit" class="btn btn--base"><?php echo e(__("Add")); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php $__env->startPush("script"); ?>
        <script>
            openModalWhenError("admin-add","#admin-add");
            function placeRandomPassword(clickedButton,placeInput) {
                $(clickedButton).click(function(){
                    var generateRandomPassword = makeRandomString(10);
                    $(placeInput).val(generateRandomPassword);
                });
            }
            placeRandomPassword(".rand_password_generator",".place_random_password");
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/admin/components/modals/add-admin.blade.php ENDPATH**/ ?>