

<?php $__env->startSection('content'); ?>

<div class="body-wrapper">
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="dashboard-header-wrapper">
                <h4 class="title"><?php echo e(__("Support Tickets")); ?></h4>
                <div class="dashboard-btn-wrapper">
                    <div class="dashboard-btn">
                        <a href="<?php echo e(setRoute('user.support.ticket.create')); ?>" class="btn--base"><i class="las la-plus me-1"></i><?php echo e(__("Add New")); ?></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__("Ticket ID")); ?></th>
                            <th><?php echo e(__("User")); ?> (<?php echo e(__("Username")); ?>) </th>
                            <th><?php echo e(__("Subject")); ?></th>
                            <th><?php echo e(__("Message")); ?></th>
                            <th><?php echo e(__("Status")); ?></th>
                            <th><?php echo e(__("Last Reply")); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $support_tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>#<?php echo e($item->token ?? ""); ?></td>
                                <td><span class="text--info"><?php echo e($item->user->username ?? ""); ?></span></td>
                                <td>

                                    <?php if($item->status == support_ticket_const()::DEFAULT): ?>
                                        <span class="text--warning"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::SOLVED): ?>
                                        <span class="text--success"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::ACTIVE): ?>
                                        <span class="text--primary"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::PENDING): ?>
                                        <span class="text--warning"><?php echo e($item->subject); ?></span>
                                    <?php endif; ?>
                                
                                </td>
                                <td><?php echo e(Str::words($item->desc , 5, '...')); ?></td>
                                <td>
                                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e($item->stringStatus->value); ?></span>
                                </td>
                                <td>
                                    <?php if(count($item->conversations) > 0): ?>
                                        <?php echo e($item->conversations->last()->created_at->format("Y-m-d H:i A") ?? ""); ?></td>
                                     <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(setRoute('user.support.ticket.conversation',encrypt($item->id))); ?>" class="btn btn--base"><i class="las la-comment"></i></a>
                                </td>                                                    
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('user.components.alerts.empty',['colspan' => 7], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>    
                    </tbody>
                </table>
            </div>
            <?php echo e(get_paginate($support_tickets)); ?>

        </div>
        
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/user/sections/support-ticket/index.blade.php ENDPATH**/ ?>