<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start testimonial
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php
    $app_local = get_default_language_code();
?>
<section class="testimonial-section pb-120">
    <div class="container">
        <div class="row">
            <div class="col-xl-6">
                <div class="section-header">
                    <span class="section-sub-titel"><i class="fas fa-briefcase-medical"></i> <?php echo e($testimonial->value->language->$app_local->title ?? ""); ?> </span>
                    <h2 class="section-title"> <?php echo e($testimonial->value->language->$app_local->heading ?? ""); ?> </h2>
                    <p><?php echo e($testimonial->value->language->$app_local->sub_heading ?? ""); ?></p>
                </div>
            </div>
        </div>
        <div class="testimonial-slider-wrapper">
            <div class="testimonial-slider">
                <div class="swiper-wrapper">
                    <?php if(isset($testimonial->value->items)): ?>
                        <?php $__currentLoopData = $testimonial->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="testimonial-item">
                                    <div class="testimonial-user-area">
                                        <div class="user-area">
                                            <img src="<?php echo e(get_image($item->image ?? "",'site-section') ?? ""); ?>" alt="user">
                                        </div>
                                        <div class="title-area">
                                            <h5><?php echo e($item->name ?? ""); ?></h5>
                                            <p>&lt; <?php echo e($item->designation ?? ""); ?> &gt;</p>
                                        </div>
                                    </div>
                                    <p class="pt-20"><?php echo e($item->language->$app_local->comment ?? ""); ?></p>
                                    <div class="testimonial-bottom-wrapper">
                                        <ul class="testimonial-icon-list">
                                            <?php for($initial = 1; $initial <= $item->rating; $initial++): ?>
                                                <li><i class="las la-star"></i></li>
                                            <?php endfor; ?>
                                        </ul>
                                        <span class="testimonial-date"><i class="las la-history"></i> <?php echo e(\Carbon\Carbon::parse($item->created_at)->format("d-m-Y")); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
                <?php if($testimonial->value->items): ?>
                    <div class="slider-nav-area">
                        <div class="slider-prev slider-nav">
                            <i class="las la-angle-left"></i>
                        </div>
                        <div class="slider-next slider-nav">
                            <i class="las la-angle-right"></i>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End testimonial
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/section/testimonial.blade.php ENDPATH**/ ?>