<div class="banner-flotting-section <?php echo e($class ?? ""); ?>">
    <div class="container">
        <div class="banner-flotting-item">
            <form class="banner-flotting-item-form" method="GET" action="<?php echo e(setRoute('frontend.doctor.search')); ?>">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <select class="form--control select2-basic" name="branch" spellcheck="false" data-ms-editor="true">
                        <option disabled selected><?php echo e(__("Select Branch")); ?></option>
                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <select class="form--control select2-basic" name="department" spellcheck="false" data-ms-editor="true">
                        <option disabled selected><?php echo e(__("Select Department")); ?></option>
                    </select>
                </div>
                <div class="form-group dr-name">
                    <input type="text" class="form--control" name="doctor" value="<?php echo e($searchDoctor ?? ""); ?>" placeholder="<?php echo e(__("Doctor Name")); ?>" spellcheck="false" data-ms-editor="true">
                    <i class="fas fa-user"></i>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn--base search-btn w-100"><i class="fas fa-search me-1"></i><?php echo e(__("Search")); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>

        $(document).ready(function(){

            var getDepartmentURL = "<?php echo e(setRoute('get.branch.departments')); ?>";

            $('select[name="branch"]').on('change',function(){
                var branch = $(this).val();

                if(branch == "" || branch == null) {
                    return false;
                }

                $.post(getDepartmentURL,{branch:branch,_token:"<?php echo e(csrf_token()); ?>"},function(response){
                    var option = '';
                    if(response.data.branch.departments.length > 0) {
                        $.each(response.data.branch.departments,function(index,item) {
                            option += `<option value="${item.hospital_department_id}">${item.department.name}</option>`
                        });
                        $("select[name=department]").html(option);
                        $("select[name=department]").select2();

                    }
                }).fail(function(response) {

                    var errorText = response.responseJSON;
                    
                });

            });
        });
   
    </script>
<?php $__env->stopPush(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/section/banner-floting.blade.php ENDPATH**/ ?>