<?php
    $app_local = get_default_language_code();
?>
<section class="blog-section pb-120">
    <div class="container">
        <div class="row">
            <div class="col-xl-6">
                <div class="section-header">
                    <span class="section-sub-titel"><i class="fas fa-briefcase-medical"></i> <?php echo e($journal_top->value->language->$app_local->title ?? ''); ?></span>
                    <h2 class="section-title"><?php echo e($journal_top->value->language->$app_local->heading ?? ''); ?></h2>
                    <p><?php echo e($journal_top->value->language->$app_local->sub_heading ?? ''); ?></p>
                </div>
            </div>
        </div>
        <div class="row mb-60-none justify-content-center">
            <?php $__currentLoopData = $journals ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-lg-4 col-md-6 mb-60">
                    <div class="blog-item">
                        <div class="thumb">
                            <img src="<?php echo e(get_image($item->data->image ?? '','site-section') ?? ''); ?>" alt="">
                        </div>
                        <div class="icon-wrapper">
                            <div class="icon">
                                
                                <i class="<?php echo e($item->data->language->$app_local->icon ?? ""); ?>"></i>
                            </div>
                        </div>
                        <div class="content">
                            <a href="<?php echo e(setRoute('frontend.journal.details',$item->slug)); ?>" class="title"><?php echo e(Str::words($item->data->language->$app_local->title ?? '',10,'...')); ?></a>
                            <p><?php echo Str::words($item->data->language->$app_local->description ?? '' , 20, '...'); ?></p>
                        </div>
                        <div class="blog-item-btn-area text-center">
                            <a href="<?php echo e(setRoute('frontend.journal.details',$item->slug)); ?>"><i class="las la-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
        </div>
        <?php if(count($journals) > 3): ?>
            <div class="blog-item-btn-area text-center mt-60">
                <a href="<?php echo e(setRoute('journals')); ?>" class="btn--base"><i class="las la-briefcase-medical me-1"></i><?php echo e(__("View More")); ?></a>
            </div>
        <?php endif; ?>
        
    </div>
</section>
<?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/section/blog.blade.php ENDPATH**/ ?>