

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Dashboard")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="dashboard-area">
        <div class="dashboard-item-area">
            <div class="row">
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Users")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_user'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--success"><?php echo e(__('Active')); ?> <?php echo e($data['active_user']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Unverified')); ?> <?php echo e($data['unverified_user']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart6" data-percent="<?php echo e($data['user_percent']); ?>"><span><?php echo e(round($data['user_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Journals")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_journals'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('Active')); ?> <?php echo e($data['active_journal']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Pending')); ?> <?php echo e($data['pending_journal']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart7" data-percent="<?php echo e($data['journal_percent']); ?>"><span><?php echo e(round($data['journal_percent'])); ?>%</span></div>
                            </div> 
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Hospital Branch")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_branches'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--success"><?php echo e(__("Active")); ?> <?php echo e($data['active_branches']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Pending")); ?> <?php echo e($data['pending_branches']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart10" data-percent="<?php echo e($data['branch_percent']); ?>"><span><?php echo e(round($data['branch_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Hospital Departments")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_departments'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__("Active")); ?> <?php echo e($data['active_departments']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Pending")); ?> <?php echo e($data['pending_departments']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart11" data-percent="<?php echo e($data['department_percent']); ?>"><span><?php echo e(round($data['department_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Hospital Tests")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_hospital_tests'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__("Active")); ?> <?php echo e($data['active_hospital_tests']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Pending")); ?> <?php echo e($data['pending_hospital_tests']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart8" data-percent="<?php echo e($data['hospital_test_percent']); ?>"><span><?php echo e(round($data['hospital_test_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Hospital Packages")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_hospital_tests'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__("Active")); ?> <?php echo e($data['active_packages']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Pending")); ?> <?php echo e($data['pending_packages']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart9" data-percent="<?php echo e($data['package_percent']); ?>"><span><?php echo e(round($data['package_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Doctors")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_doctors'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__("Active")); ?> <?php echo e($data['active_doctors']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Pending")); ?> <?php echo e($data['pending_doctors']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart13" data-percent="<?php echo e($data['doctor_percent']); ?>"><span><?php echo e(round($data['doctor_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Doctor Appointments")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['appointment_booking'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__("Confirm")); ?> <?php echo e($data['active_appointment']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Pending")); ?> <?php echo e($data['pending_appointment']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart12" data-percent="<?php echo e($data['appointment_percent']); ?>"><span><?php echo e(round($data['appointment_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Home Service Bookings")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_home_service'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__("Active")); ?> <?php echo e($data['active_home_service']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Pending")); ?> <?php echo e($data['pending_home_service']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart14" data-percent="<?php echo e($data['home_service_percent']); ?>"><span><?php echo e(round($data['home_service_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="chart-area mt-15">
        <div class="row mb-15-none">
            <div class="col-xxxl-6 col-xxl-3 col-xl-6 col-lg-6 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title"><?php echo e(__("User Analytics Chart")); ?></h5>
                    </div>
                    <div class="chart-container">
                        <div id="chart1" class="balance-chart" data-user_chart_data="<?php echo e(json_encode($data['user_chart_data'])); ?>"></div>
                    </div>
                    <div class="chart-area-footer">
                        <div class="chart-btn">
                            <a href="<?php echo e(setRoute('admin.users.index')); ?>" class="btn--base w-100"><?php echo e(__("View User")); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title"><?php echo e(__("Doctor Appointment Booking Chart")); ?></h5>
                    </div>
                    <div class="chart-container">
                        <div id="chart2" class="sales-chart" data-appointment_booking_chart="<?php echo e(json_encode($data['appointment_booking_chart'])); ?>"></div>
                    </div>
                    <div class="chart-area-footer">
                        <div class="chart-btn">
                            <a href="<?php echo e(setRoute('admin.booking.index')); ?>" class="btn--base w-100"><?php echo e(__("View Doctor Appointment")); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxxl-12 col-xxl-3 col-xl-12 col-lg-12 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title"><?php echo e(__("Home Service Chart")); ?></h5>
                    </div>
                    <div class="chart-container">
                        <div id="chart3" data-home_service_chart="<?php echo e(json_encode($data['home_service_chart'])); ?>"></div>
                    </div>
                    <div class="chart-area-footer">
                        <div class="chart-btn">
                            <a href="<?php echo e(setRoute("admin.home.service.index")); ?>" class="btn--base w-100"><?php echo e(__("View Home Service")); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
    <div class="table-area mt-15">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e(__("Recent Appointments")); ?></h5>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__("Patient Name")); ?></th>
                            <th><?php echo e(__("Email")); ?></th>
                            <th><?php echo e(__("Phone")); ?></th>
                            <th><?php echo e(__("Age")); ?></th>
                            <th><?php echo e(__("Gender")); ?></th>
                            <th><?php echo e(__("Type")); ?></th>
                            <th><?php echo e(__("Doctor Name")); ?></th>
                            <th><?php echo e(__("Speciality")); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $recent_appointment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                
                                <td><span><?php echo e($data->name ?? ""); ?></span></td>
                                <td><?php echo e($data->email ?? ""); ?></td>
                                <td><?php echo e($data->phone ?? ""); ?></td>
                                <td><?php echo e($data->age ?? ""); ?></td>
                                <td class="text-capitalize"><?php echo e($data->gender ?? ""); ?></td>
                                <td class="text-capitalize"><?php echo e($data->type ?? ""); ?></td>
                                <td><span class="text--info"><?php echo e($data->doctors->name ?? ""); ?></span></td>
                                <td><?php echo e($data->doctors->speciality ?? ""); ?></td>
                                <td>
                                    <?php echo $__env->make('admin.components.link.custom',[
                                        'href'          => "#send-reply",
                                        'class'         => "btn btn--base reply-button modal-btn",
                                        'icon'          => "las la-reply-all",
                                        'permission'    => "admin.booking.messages.reply",
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <a href="<?php echo e(setRoute('admin.booking.details',$data->slug)); ?>" class="btn btn--base btn--primary"><i class="las la-info-circle"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 10], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                        
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <?php if(admin_permission_by_name("admin.booking.messages.reply")): ?>
        <div id="send-reply" class="mfp-hide large">
            <div class="modal-data">
                <div class="modal-header px-0">
                    <h5 class="modal-title"><?php echo e(__("Send Reply")); ?></h5>
                </div>
                <div class="modal-form-data">
                    <form class="card-form" action="<?php echo e(setRoute('admin.booking.messages.reply')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="target" value="<?php echo e(old('target')); ?>">
                        <div class="row mb-10-none">
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                    'label'         => __("Subject")."*",
                                    'name'          => "subject",
                                    'data_limit'    => 150,
                                    'placeholder'   => __("Write Subject")."...",
                                    'value'         => old('subject'),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input-text-rich',[
                                    'label'         => __("Details")."*",
                                    'name'          => "message",
                                    'value'         => old('message'),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.button.form-btn',[
                                    'class'         => "w-100 btn-loading",
                                    'permission'    => "admin.subscriber.send.mail",
                                    'text'          => __("Send Email"),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        openModalWhenError("send-reply","#send-reply");
        $(".reply-button").click(function(){
            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            $("#send-reply").find("input[name=target]").val(oldData.id);
        });
    </script>

    <script>
        // apex-chart
var chart2 = $('#chart2');
var appointment_booking_chart = chart2.data('appointment_booking_chart');

var options = {
  series: appointment_booking_chart,
  chart: {
  width: 350,
  type: 'pie'
},
colors: ['#5A5278', '#6F6593', '#8075AA', '#A192D9'],
labels: ['<?php echo e(__("All")); ?>', '<?php echo e(__("Confirm")); ?>', '<?php echo e(__("Pending")); ?>'],
responsive: [{
  breakpoint: 1480,
  options: {
    chart: {
      width: 280
    },
    legend: {
      position: 'bottom'
    }
  },
  breakpoint: 1199,
  options: {
    chart: {
      width: 380
    },
    legend: {
      position: 'bottom'
    }
  },
  breakpoint: 575,
  options: {
    chart: {
      width: 280
    },
    legend: {
      position: 'bottom'
    }
  }
}],
legend: {
  position: 'bottom'
},
};

var chart = new ApexCharts(document.querySelector("#chart2"), options);
chart.render();







var chart1 = $('#chart1');
var user_chart_data = chart1.data('user_chart_data');

var options = {
  series: user_chart_data,
  chart: {
  width: 350,
  type: 'pie'
},
colors: ['#5A5278', '#6F6593', '#8075AA', '#A192D9'],
labels: ['<?php echo e(__("Active")); ?>', '<?php echo e(__("Unverified")); ?>', '<?php echo e(__("Banned")); ?>', '<?php echo e(__("All")); ?>'],
responsive: [{
  breakpoint: 1480,
  options: {
    chart: {
      width: 280
    },
    legend: {
      position: 'bottom'
    }
  },
  breakpoint: 1199,
  options: {
    chart: {
      width: 380
    },
    legend: {
      position: 'bottom'
    }
  },
  breakpoint: 575,
  options: {
    chart: {
      width: 280
    },
    legend: {
      position: 'bottom'
    }
  }
}],
legend: {
  position: 'bottom'
},
};

var chart = new ApexCharts(document.querySelector("#chart1"), options);
chart.render();

var chart3 = $("#chart3");
var home_service_chart = chart3.data('home_service_chart');
var options = {
  series: home_service_chart,
  chart: {
  width: 350,
  type: 'donut',
},
colors: ['#5A5278', '#6F6593', '#8075AA', '#A192D9'],
labels: ['<?php echo e(__("All")); ?>', '<?php echo e(__("Active")); ?>', '<?php echo e(__("Pending")); ?>'],
legend: {
    position: 'bottom'
},
responsive: [{
  breakpoint: 1600,
  options: {
    chart: {
      width: 100,
    },
    legend: {
      position: 'bottom'
    }
  },
  breakpoint: 1199,
  options: {
    chart: {
      width: 380
    },
    legend: {
      position: 'bottom'
    }
  },
  breakpoint: 575,
  options: {
    chart: {
      width: 280
    },
    legend: {
      position: 'bottom'
    }
  }
}]
};

var chart = new ApexCharts(document.querySelector("#chart3"), options);
chart.render();

    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/admin/sections/dashboard/index.blade.php ENDPATH**/ ?>