<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\SiteSections;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Constants\SiteSectionConst;
use App\Models\Admin\Journal;
use Illuminate\Support\Str;

class SiteSectionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = array(
          array('key' => 'site_cookie','value' => '{"status":true,"link":"https:\\/\\/www.appdevs.net\\/policy","desc":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book."}','status' => '1','serialize' => NULL,'created_at' => '2023-06-07 10:31:14','updated_at' => '2023-06-07 10:31:14'),
          array('key' => 'banner-section','value' => '{"items":{"648ea63ba970b":{"language":{"en":{"heading":"Your Trusted Online Hospital Doctor Booking Platform","sub_heading":"Book, Heal, and Thrive with ADoctor\'s Seamless Healthcare Access."},"es":{"heading":"Su plataforma de reserva de m\\u00e9dicos de hospital en l\\u00ednea de confianza","sub_heading":"Reserve, sane y prospere con el acceso continuo a la atenci\\u00f3n m\\u00e9dica de ADoctor."},"ar":{"heading":"\\u0645\\u0646\\u0635\\u0629 \\u062d\\u062c\\u0632 \\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0634\\u0641\\u0649 \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a","sub_heading":"\\u0627\\u062d\\u062c\\u0632 \\u0648\\u0639\\u0627\\u0644\\u062c \\u0648\\u0627\\u0632\\u062f\\u0647\\u0631 \\u0645\\u0639 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0633 \\u0644\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0644\\u0644\\u0637\\u0628\\u064a\\u0628"}},"id":"648ea63ba970b","status":1,"image":"seeder\\/banner.webp"},"648ea6499ff94":{"language":{"en":{"heading":"Empowering Your Health, One Appointment at a Time","sub_heading":"Where Expertise Meets Convenience for Your Wellbeing."},"es":{"heading":"Empoderando su salud, una cita a la vez","sub_heading":"Donde la experiencia se encuentra con la conveniencia para su bienestar"},"ar":{"heading":"\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0635\\u062d\\u062a\\u0643\\u060c \\u0645\\u0648\\u0639\\u062f \\u0648\\u0627\\u062d\\u062f \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0631\\u0629","sub_heading":"\\u062d\\u064a\\u062b \\u062a\\u062c\\u062a\\u0645\\u0639 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0631\\u0627\\u062d\\u0629 \\u0644\\u0631\\u0641\\u0627\\u0647\\u064a\\u062a\\u0643"}},"id":"648ea6499ff94","status":1,"image":"seeder\\/banner2.webp"}}}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:37:49','updated_at' => '2023-09-14 10:18:52'),
          array('key' => 'about-section','value' => '{"images":{"image":"seeder\\/about.webp"},"language":{"en":{"title":"About Company","heading":"Your Personalised Healthcare Companion","sub_heading":"We believe that accessing quality healthcare should be effortless, transparent, and empowering. Our mission is to bridge the gap between patients and doctors, revolutionizing the way healthcare appointments are booked and managed. With our user-friendly platform, we provide you with the tools and information to make informed decisions about your health. Whether you need a routine check-up or specialized care, ADoctor is here to accompany you on your healthcare journey, ensuring you receive the best medical attention you deserve.","video_link":"https:\\/\\/www.youtube.com\\/embed\\/7p6hG3plQj4","statistic_first_title":"Service Provider","statistic_first_value":"25000","statistic_second_title":"Total User","statistic_second_value":"4700000","statistic_last_title":"Happy Patient","statistic_last_value":"5340000"},"es":{"title":"Acerca de la compa\\u00f1\\u00eda","heading":"Su compa\\u00f1ero de atenci\\u00f3n m\\u00e9dica personalizada","sub_heading":"Creemos que acceder a una atenci\\u00f3n m\\u00e9dica de calidad debe ser f\\u00e1cil, transparente y empoderador. Nuestra misi\\u00f3n es cerrar la brecha entre pacientes y m\\u00e9dicos, revolucionando la forma en que se reservan y gestionan las citas de atenci\\u00f3n m\\u00e9dica. Con nuestra plataforma f\\u00e1cil de usar, le brindamos las herramientas y la informaci\\u00f3n para tomar decisiones informadas sobre su salud. Ya sea que necesite un chequeo de rutina o atenci\\u00f3n especializada, ADoctor est\\u00e1 aqu\\u00ed para acompa\\u00f1arlo en su viaje de atenci\\u00f3n m\\u00e9dica, asegurando que reciba la mejor atenci\\u00f3n m\\u00e9dica que se merece.","video_link":"https:\\/\\/www.youtube.com\\/embed\\/7p6hG3plQj4","statistic_first_title":"Proveedor de servicio","statistic_first_value":"25000","statistic_second_title":"Usuario total","statistic_second_value":"4700000","statistic_last_title":"Paciente feliz","statistic_last_value":"5340000"},"ar":{"title":"\\u0639\\u0646 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629","heading":"\\u0631\\u0641\\u064a\\u0642\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a \\u0641\\u064a \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629","sub_heading":"\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0623\\u0646 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u062c\\u064a\\u062f\\u0629 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u0633\\u0647\\u0644\\u0627\\u064b \\u0648\\u0634\\u0641\\u0627\\u0641\\u064b\\u0627 \\u0648\\u0645\\u0645\\u0643\\u0646\\u064b\\u0627. \\u0645\\u0647\\u0645\\u062a\\u0646\\u0627 \\u0647\\u064a \\u0633\\u062f \\u0627\\u0644\\u0641\\u062c\\u0648\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0648\\u0627\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621\\u060c \\u0648\\u0625\\u062d\\u062f\\u0627\\u062b \\u062b\\u0648\\u0631\\u0629 \\u0641\\u064a \\u0637\\u0631\\u064a\\u0642\\u0629 \\u062d\\u062c\\u0632 \\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0648\\u0625\\u062f\\u0627\\u0631\\u062a\\u0647\\u0627. \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u060c \\u0646\\u0648\\u0641\\u0631 \\u0644\\u0643 \\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0627\\u0632\\u0645\\u0629 \\u0644\\u0627\\u062a\\u062e\\u0627\\u0630 \\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0645\\u0633\\u062a\\u0646\\u064a\\u0631\\u0629 \\u0628\\u0634\\u0623\\u0646 \\u0635\\u062d\\u062a\\u0643. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u0628\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0641\\u062d\\u0635 \\u0631\\u0648\\u062a\\u064a\\u0646\\u064a \\u0623\\u0648 \\u0631\\u0639\\u0627\\u064a\\u0629 \\u0645\\u062a\\u062e\\u0635\\u0635\\u0629\\u060c \\u0641\\u0625\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0645\\u0648\\u062c\\u0648\\u062f \\u0644\\u0645\\u0631\\u0627\\u0641\\u0642\\u062a\\u0643 \\u0641\\u064a \\u0631\\u062d\\u0644\\u0629 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u062d\\u0635\\u0648\\u0644\\u0643 \\u0639\\u0644\\u0649 \\u0623\\u0641\\u0636\\u0644 \\u0631\\u0639\\u0627\\u064a\\u0629 \\u0637\\u0628\\u064a\\u0629 \\u062a\\u0633\\u062a\\u062d\\u0642\\u0647\\u0627.","video_link":"https:\\/\\/www.youtube.com\\/embed\\/7p6hG3plQj4","statistic_first_title":"\\u0645\\u0642\\u062f\\u0645 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629","statistic_first_value":"25000","statistic_second_title":"\\u0625\\u062c\\u0645\\u0627\\u0644\\u064a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645","statistic_second_value":"4700000","statistic_last_title":"\\u0645\\u0631\\u064a\\u0636 \\u0633\\u0639\\u064a\\u062f","statistic_last_value":"5340013"}},"items":{"648ea6a0a671d":{"language":{"en":{"title":"Doctor Booking Made Easy"},"es":{"title":"Reserva de m\\u00e9dico f\\u00e1cil"},"ar":{"title":"\\u062d\\u062c\\u0632 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0623\\u0635\\u0628\\u062d \\u0633\\u0647\\u0644\\u0627\\u064b"}},"id":"648ea6a0a671d"},"648ea6a996ea2":{"language":{"en":{"title":"Transparent Doctor Profiles"},"es":{"title":"Perfiles de doctora transparentes"},"ar":{"title":"\\u0645\\u0644\\u0641\\u0627\\u062a \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u0629"}},"id":"648ea6a996ea2"},"648ea6b0a501f":{"language":{"en":{"title":"Branch Selection"},"es":{"title":"Selecci\\u00f3n de sucursales"},"ar":{"title":"\\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0641\\u0631\\u0639"}},"id":"648ea6b0a501f"},"648ea6b99da59":{"language":{"en":{"title":"Online Medical Records"},"es":{"title":"Registros m\\u00e9dicos en l\\u00ednea"},"ar":{"title":"\\u0627\\u0644\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a"}},"id":"648ea6b99da59"},"648ea6c158e9f":{"language":{"en":{"title":"Appointment Reminders"},"es":{"title":"Recordatorios de citas"},"ar":{"title":"\\u062a\\u0630\\u0643\\u064a\\u0631\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u064a\\u064a\\u0646"}},"id":"648ea6c158e9f"},"648ea6d149933":{"language":{"en":{"title":"24\\/7 Customer Support"},"es":{"title":"Atenci\\u00f3n al cliente 24\\/7"},"ar":{"title":"\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u0645\\u062f\\u0627\\u0631 24 \\u0633\\u0627\\u0639\\u0629 \\u0637\\u0648\\u0627\\u0644 \\u0623\\u064a\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0628\\u0648\\u0639"}},"id":"648ea6d149933"},"64c23f5048e36":{"language":{"en":{"title":"Investigation"},"es":{"title":"Investigaci\\u00f3n"},"ar":{"title":"\\u062a\\u062d\\u0642\\u064a\\u0642"}},"id":"64c23f5048e36"},"64c242baf111b":{"language":{"en":{"title":"Trustworthy"},"es":{"title":"Confiable"},"ar":{"title":"\\u062c\\u062f\\u064a\\u0631 \\u0628\\u0627\\u0644\\u062b\\u0642\\u0629"}},"id":"64c242baf111b"}}}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:39:20','updated_at' => '2023-09-14 10:25:15'),
          array('key' => 'faq-section','value' => '{"language":{"en":{"title":"FAQ","heading":"Have questions about using ADoctor\'s platform?","sub_heading":"Find answers to the most commonly asked queries here. From registration to booking appointments and more, we\'ve got you covered!"},"es":{"title":"Preguntas m\\u00e1s frecuentes","heading":"\\u00bfTiene preguntas sobre el uso de la plataforma de ADoctor?","sub_heading":"Encuentre aqu\\u00ed las respuestas a las consultas m\\u00e1s frecuentes. Desde el registro hasta la reserva de citas y m\\u00e1s, \\u00a1lo tenemos cubierto!"},"ar":{"title":"\\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u0627\\u062a","heading":"\\u0647\\u0644 \\u0644\\u062f\\u064a\\u0643 \\u0623\\u0633\\u0626\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0646\\u0635\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628\\u061f","sub_heading":"\\u0627\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0644\\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0634\\u064a\\u0648\\u0639\\u064b\\u0627 \\u0647\\u0646\\u0627. \\u0628\\u062f\\u0621\\u064b\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0648\\u062d\\u062a\\u0649 \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0648\\u0627\\u0644\\u0645\\u0632\\u064a\\u062f\\u060c \\u0646\\u062d\\u0646 \\u0646\\u0648\\u0641\\u0631 \\u0644\\u0643 \\u0643\\u0644 \\u0645\\u0627 \\u062a\\u062d\\u062a\\u0627\\u062c\\u0647!"}},"items":{"648ea71919eb8":{"language":{"en":{"question":"How do I create an account on ADoctor?","answer":"Creating an account with ADoctor is easy! Simply click on the \\"Sign Up\\" button on the homepage, fill in the required information, and you\'ll have your account ready in no time."},"es":{"question":"\\u00bfC\\u00f3mo creo una cuenta en A Doctor?","answer":"\\u00a1Crear una cuenta con A Doctor es f\\u00e1cil! Simplemente haga clic en el bot\\u00f3n \\"Registrarse\\" en la p\\u00e1gina de inicio, complete la informaci\\u00f3n requerida y tendr\\u00e1 su cuenta lista en poco tiempo."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0642\\u0648\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628\\u061f","answer":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628 \\u0645\\u0639 \\u0637\\u0628\\u064a\\u0628 \\u0623\\u0645\\u0631 \\u0633\\u0647\\u0644! \\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u0627\\u0644\\u0646\\u0642\\u0631 \\u0639\\u0644\\u0649 \\u0632\\u0631 \\"\\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644\\" \\u0627\\u0644\\u0645\\u0648\\u062c\\u0648\\u062f \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0635\\u0641\\u062d\\u0629 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629\\u060c \\u0648\\u0645\\u0644\\u0621 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0637\\u0644\\u0648\\u0628\\u0629\\u060c \\u0648\\u0633\\u064a\\u0643\\u0648\\u0646 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u062c\\u0627\\u0647\\u0632\\u064b\\u0627 \\u0641\\u064a \\u0623\\u064a \\u0648\\u0642\\u062a \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0648\\u0642\\u0627\\u062a."}},"status":1,"id":"648ea71919eb8"},"648ea728851d7":{"language":{"en":{"question":"Is there a fee for using ADoctor\'s services?","answer":"No, signing up and using ADoctor\'s platform to book appointments is completely free. You only pay for the medical services received during your appointment."},"es":{"question":"\\u00bfHay una tarifa por usar los servicios de ADoctor?","answer":"No, registrarse y utilizar la plataforma de ADoctor para reservar citas es completamente gratuito. Solo paga por los servicios m\\u00e9dicos recibidos durante su cita."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0631\\u0633\\u0648\\u0645 \\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628\\u061f","answer":"\\u0644\\u0627\\u060c \\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0646\\u0635\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0644\\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0645\\u062c\\u0627\\u0646\\u064a \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627. \\u0623\\u0646\\u062a \\u062a\\u062f\\u0641\\u0639 \\u0641\\u0642\\u0637 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062a\\u0644\\u0642\\u0627\\u0647\\u0627 \\u062e\\u0644\\u0627\\u0644 \\u0645\\u0648\\u0639\\u062f\\u0643."}},"status":1,"id":"648ea728851d7"},"648ea73842292":{"language":{"en":{"question":"How do I book an appointment with a doctor?","answer":"To book an appointment, first, log in to your ADoctor account. Then, choose your preferred branch, select your desired doctor, and pick an available time slot that suits your schedule. Click \\"Book Appointment,\\" and you\'re all set!"},"es":{"question":"\\u00bfC\\u00f3mo reservo una cita con un m\\u00e9dico?","answer":"Para reservar una cita, primero inicie sesi\\u00f3n en su cuenta ADoctor. Luego, elija su sucursal preferida, seleccione el m\\u00e9dico que desee y elija un horario disponible que se adapte a su horario. Haz clic en \\"Reservar cita\\" y \\u00a1listo!"},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f \\u0645\\u0639 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628\\u061f","answer":"\\u0644\\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f\\u060c \\u0642\\u0645 \\u0623\\u0648\\u0644\\u0627\\u064b \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643. \\u0628\\u0639\\u062f \\u0630\\u0644\\u0643\\u060c \\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0641\\u0631\\u0639 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644 \\u0644\\u062f\\u064a\\u0643\\u060c \\u062b\\u0645 \\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0645\\u0637\\u0644\\u0648\\u0628\\u060c \\u062b\\u0645 \\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0641\\u062a\\u0631\\u0629 \\u0627\\u0644\\u0632\\u0645\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0646\\u0627\\u0633\\u0628 \\u062c\\u062f\\u0648\\u0644\\u0643 \\u0627\\u0644\\u0632\\u0645\\u0646\\u064a. \\u0627\\u0646\\u0642\\u0631 \\u0639\\u0644\\u0649 \\"\\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f\\"\\u060c \\u0648\\u0633\\u062a\\u0643\\u0648\\u0646 \\u062c\\u0627\\u0647\\u0632\\u064b\\u0627!"}},"status":1,"id":"648ea73842292"},"648ea74d3937f":{"language":{"en":{"question":"Can I change or cancel my appointment after booking?","answer":"Yes, you can easily change or cancel your appointment through your ADoctor account. However, please be considerate and notify us at least 24 hours in advance if you need to reschedule or cancel to allow other patients to book that slot."},"es":{"question":"\\u00bfPuedo cambiar o cancelar mi cita despu\\u00e9s de reservar?","answer":"S\\u00ed, puede cambiar o cancelar su cita f\\u00e1cilmente a trav\\u00e9s de su cuenta ADoctor. Sin embargo, sea considerado y notif\\u00edquenos con al menos 24 horas de anticipaci\\u00f3n si necesita reprogramar o cancelar para permitir que otros pacientes reserven ese horario."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0623\\u0648 \\u0625\\u0644\\u063a\\u0627\\u0621 \\u0645\\u0648\\u0639\\u062f\\u064a \\u0628\\u0639\\u062f \\u0627\\u0644\\u062d\\u062c\\u0632\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0623\\u0648 \\u0625\\u0644\\u063a\\u0627\\u0621 \\u0645\\u0648\\u0639\\u062f\\u0643 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u064a\\u0631\\u062c\\u0649 \\u0645\\u0631\\u0627\\u0639\\u0627\\u0629 \\u0630\\u0644\\u0643 \\u0648\\u0625\\u062e\\u0637\\u0627\\u0631\\u0646\\u0627 \\u0642\\u0628\\u0644 24 \\u0633\\u0627\\u0639\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0642\\u0644 \\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u0628\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u062c\\u062f\\u0648\\u0644\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0625\\u0644\\u063a\\u0627\\u0621 \\u0644\\u0644\\u0633\\u0645\\u0627\\u062d \\u0644\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0627\\u0644\\u0622\\u062e\\u0631\\u064a\\u0646 \\u0628\\u062d\\u062c\\u0632 \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0641\\u062a\\u0631\\u0629."}},"status":1,"id":"648ea74d3937f"},"64c24449819b1":{"language":{"en":{"question":"How can I access my medical records and test results?","answer":"Your medical records and test results are securely stored in your ADoctor account. Log in, go to the \\"Medical Records\\" section, and you\'ll find all your relevant information organized for easy access."},"es":{"question":"\\u00bfC\\u00f3mo puedo acceder a mis registros m\\u00e9dicos y resultados de pruebas?","answer":"Sus registros m\\u00e9dicos y los resultados de las pruebas se almacenan de forma segura en su cuenta de ADoctor. Inicie sesi\\u00f3n, vaya a la secci\\u00f3n \\"Registros m\\u00e9dicos\\" y encontrar\\u00e1 toda su informaci\\u00f3n relevante organizada para facilitar el acceso."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0633\\u062c\\u0644\\u0627\\u062a\\u064a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0648\\u0646\\u062a\\u0627\\u0626\\u062c \\u0627\\u0644\\u0627\\u062e\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a\\u061f","answer":"\\u064a\\u062a\\u0645 \\u062a\\u062e\\u0632\\u064a\\u0646 \\u0633\\u062c\\u0644\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0648\\u0646\\u062a\\u0627\\u0626\\u062c \\u0627\\u0644\\u0627\\u062e\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643. \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644\\u060c \\u0648\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\"\\u0627\\u0644\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629\\"\\u060c \\u0648\\u0633\\u062a\\u062c\\u062f \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0630\\u0627\\u062a \\u0627\\u0644\\u0635\\u0644\\u0629 \\u0645\\u0646\\u0638\\u0645\\u0629 \\u0644\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u064a\\u0647\\u0627."}},"status":1,"id":"64c24449819b1"},"64c2446ce0a4e":{"language":{"en":{"question":"What should I do if I face technical issues with the website?","answer":"If you encounter any technical difficulties or have trouble navigating the website, don\'t worry! Reach out to our 24\\/7 customer support team through our helpline or email, and we\'ll assist you promptly."},"es":{"question":"\\u00bfQu\\u00e9 debo hacer si tengo problemas t\\u00e9cnicos con el sitio web?","answer":"Si encuentra alguna dificultad t\\u00e9cnica o tiene problemas para navegar por el sitio web, \\u00a1no se preocupe! Comun\\u00edquese con nuestro equipo de atenci\\u00f3n al cliente las 24 horas del d\\u00eda, los 7 d\\u00edas de la semana a trav\\u00e9s de nuestra l\\u00ednea de ayuda o correo electr\\u00f3nico, y lo ayudaremos de inmediato."},"ar":{"question":"\\u0645\\u0627\\u0630\\u0627 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0641\\u0639\\u0644 \\u0625\\u0630\\u0627 \\u0648\\u0627\\u062c\\u0647\\u062a \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u0646\\u064a\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0648\\u0642\\u0639\\u061f","answer":"\\u0625\\u0630\\u0627 \\u0648\\u0627\\u062c\\u0647\\u062a \\u0623\\u064a \\u0635\\u0639\\u0648\\u0628\\u0627\\u062a \\u062a\\u0642\\u0646\\u064a\\u0629 \\u0623\\u0648 \\u0648\\u0627\\u062c\\u0647\\u062a \\u0645\\u0634\\u0643\\u0644\\u0629 \\u0641\\u064a \\u062a\\u0635\\u0641\\u062d \\u0627\\u0644\\u0645\\u0648\\u0642\\u0639\\u060c \\u0641\\u0644\\u0627 \\u062a\\u0642\\u0644\\u0642! \\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639 \\u0641\\u0631\\u064a\\u0642 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0639\\u0645\\u0644 \\u0639\\u0644\\u0649 \\u0645\\u062f\\u0627\\u0631 24 \\u0633\\u0627\\u0639\\u0629 \\u0637\\u0648\\u0627\\u0644 \\u0623\\u064a\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0628\\u0648\\u0639 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062e\\u0637 \\u0627\\u0644\\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a\\u060c \\u0648\\u0633\\u0646\\u0633\\u0627\\u0639\\u062f\\u0643 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631."}},"status":1,"id":"64c2446ce0a4e"},"64c24490effd1":{"language":{"en":{"question":"Can I provide feedback or review a doctor\'s service on ADoctor?","answer":"Yes, your feedback is valuable to us. After your appointment, you\'ll have the opportunity to leave a review and rate your experience with the doctor. Your feedback helps us maintain the highest standards of service."},"es":{"question":"\\u00bfPuedo proporcionar comentarios o revisar el servicio de un m\\u00e9dico en ADoctor?","answer":"S\\u00ed, su opini\\u00f3n es valiosa para nosotros. Despu\\u00e9s de su cita, tendr\\u00e1 la oportunidad de dejar un comentario y calificar su experiencia con el m\\u00e9dico. Sus comentarios nos ayudan a mantener los m\\u00e1s altos est\\u00e1ndares de servicio."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0645\\u0644\\u0627\\u062d\\u0638\\u0627\\u062a \\u0623\\u0648 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u062e\\u062f\\u0645\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0639\\u0644\\u0649 \\u0645\\u0648\\u0642\\u0639 \\"\\u0627\\u0644\\u0637\\u0628\\u064a\\u0628\\"\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0645\\u0644\\u0627\\u062d\\u0638\\u0627\\u062a\\u0643 \\u0630\\u0627\\u062a \\u0642\\u064a\\u0645\\u0629 \\u0628\\u0627\\u0644\\u0646\\u0633\\u0628\\u0629 \\u0644\\u0646\\u0627. \\u0628\\u0639\\u062f \\u0645\\u0648\\u0639\\u062f\\u0643\\u060c \\u0633\\u062a\\u062a\\u0627\\u062d \\u0644\\u0643 \\u0627\\u0644\\u0641\\u0631\\u0635\\u0629 \\u0644\\u062a\\u0631\\u0643 \\u062a\\u0639\\u0644\\u064a\\u0642 \\u0648\\u062a\\u0642\\u064a\\u064a\\u0645 \\u062a\\u062c\\u0631\\u0628\\u062a\\u0643 \\u0645\\u0639 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628. \\u062a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u0644\\u0627\\u062d\\u0638\\u0627\\u062a\\u0643 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629."}},"status":1,"id":"64c24490effd1"},"64c244c17368a":{"language":{"en":{"question":"Does ADoctor cover all medical specialties?","answer":"ADoctor collaborates with a diverse network of doctors across various medical specialties. While we strive to offer a comprehensive range of services, the availability of specific specialties may vary depending on your chosen branch."},"es":{"question":"\\u00bfADoctor cubre todas las especialidades m\\u00e9dicas?","answer":"ADoctor colabora con una red diversa de m\\u00e9dicos en varias especialidades m\\u00e9dicas. Si bien nos esforzamos por ofrecer una amplia gama de servicios, la disponibilidad de especialidades espec\\u00edficas puede variar seg\\u00fan la sucursal elegida."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u063a\\u0637\\u064a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u062a\\u062e\\u0635\\u0635\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629\\u061f","answer":"\\u064a\\u062a\\u0639\\u0627\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0645\\u0639 \\u0634\\u0628\\u0643\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621 \\u0641\\u064a \\u0645\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u062a\\u062e\\u0635\\u0635\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629. \\u0628\\u064a\\u0646\\u0645\\u0627 \\u0646\\u0633\\u0639\\u0649 \\u062c\\u0627\\u0647\\u062f\\u064a\\u0646 \\u0644\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0634\\u0627\\u0645\\u0644\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a\\u060c \\u0642\\u062f \\u064a\\u062e\\u062a\\u0644\\u0641 \\u062a\\u0648\\u0641\\u0631 \\u062a\\u062e\\u0635\\u0635\\u0627\\u062a \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0648\\u0641\\u0642\\u064b\\u0627 \\u0644\\u0644\\u0641\\u0631\\u0639 \\u0627\\u0644\\u0630\\u064a \\u0627\\u062e\\u062a\\u0631\\u062a\\u0647."}},"status":1,"id":"64c244c17368a"}}}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:41:12','updated_at' => '2023-09-14 10:32:42'),
          array('key' => 'testimonial-section','value' => '{"language":{"en":{"title":"Testimonials","heading":"What our users have to say about their experiences","sub_heading":"We value their feedback and continuously strive to provide the best possible service to all our users."},"es":{"title":"Testimonios","heading":"Lo que nuestros usuarios tienen que decir sobre sus experiencias","sub_heading":"Valoramos sus comentarios y nos esforzamos continuamente para brindar el mejor servicio posible a todos nuestros usuarios."},"ar":{"title":"\\u0627\\u0644\\u0634\\u0647\\u0627\\u062f\\u0627\\u062a - \\u0627\\u0644\\u062a\\u0648\\u0635\\u064a\\u0627\\u062a","heading":"\\u0645\\u0627 \\u064a\\u0642\\u0648\\u0644\\u0647 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u0648\\u0646\\u0627 \\u0639\\u0646 \\u062a\\u062c\\u0627\\u0631\\u0628\\u0647\\u0645","sub_heading":"\\u0646\\u062d\\u0646 \\u0646\\u0642\\u062f\\u0631 \\u0645\\u0644\\u0627\\u062d\\u0638\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0646\\u0633\\u0639\\u0649 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0644\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0623\\u0641\\u0636\\u0644 \\u062e\\u062f\\u0645\\u0629 \\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u062c\\u0645\\u064a\\u0639 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u0627."}},"items":{"648ea79d0a46d":{"language":{"en":{"comment":"ADoctor has been a game-changer for me! Booking appointments used to be a hassle, but with their user-friendly platform, I can now find the right doctor and schedule an appointment in no time. The transparent doctor profiles and patient reviews helped me make informed decisions about my healthcare. Thank you, ADoctor, for making my life easier!"},"es":{"comment":"\\u00a1ADoctor ha sido un cambio de juego para m\\u00ed! Reservar citas sol\\u00eda ser una molestia, pero con su plataforma f\\u00e1cil de usar, ahora puedo encontrar el m\\u00e9dico adecuado y programar una cita en poco tiempo. Los perfiles transparentes de los m\\u00e9dicos y las revisiones de los pacientes me ayudaron a tomar decisiones informadas sobre mi atenci\\u00f3n m\\u00e9dica. \\u00a1Gracias, ADoctor, por hacerme la vida m\\u00e1s f\\u00e1cil!"},"ar":{"comment":"\\u0644\\u0642\\u062f \\u0643\\u0627\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0628\\u0645\\u062b\\u0627\\u0628\\u0629 \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0641\\u064a \\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u0644\\u0639\\u0628\\u0629 \\u0628\\u0627\\u0644\\u0646\\u0633\\u0628\\u0629 \\u0644\\u064a! \\u0643\\u0627\\u0646 \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0623\\u0645\\u0631\\u0627\\u064b \\u0635\\u0639\\u0628\\u0627\\u064b\\u060c \\u0648\\u0644\\u0643\\u0646 \\u0645\\u0639 \\u0645\\u0646\\u0635\\u062a\\u0647\\u0645 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u060c \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0633\\u0628 \\u0648\\u062a\\u062d\\u062f\\u064a\\u062f \\u0645\\u0648\\u0639\\u062f \\u0641\\u064a \\u0623\\u064a \\u0648\\u0642\\u062a \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0648\\u0642\\u0627\\u062a. \\u0644\\u0642\\u062f \\u0633\\u0627\\u0639\\u062f\\u062a\\u0646\\u064a \\u0645\\u0644\\u0641\\u0627\\u062a \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0627\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u0629 \\u0648\\u0645\\u0631\\u0627\\u062c\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0639\\u0644\\u0649 \\u0627\\u062a\\u062e\\u0627\\u0630 \\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0645\\u0633\\u062a\\u0646\\u064a\\u0631\\u0629 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u064a. \\u0634\\u0643\\u0631\\u0627 \\u0644\\u0643 \\u062f\\u0643\\u062a\\u0648\\u0631\\u060c \\u0644\\u0623\\u0646\\u0643 \\u062c\\u0639\\u0644\\u062a \\u062d\\u064a\\u0627\\u062a\\u064a \\u0623\\u0633\\u0647\\u0644!"}},"id":"648ea79d0a46d","image":"seeder\\/test1.webp","name":"John Smith","designation":"Support","rating":"4","created_at":"2023-06-18T06:43:41.051391Z"},"648ea7dd1c1c6":{"language":{"en":{"comment":"I had my reservations about booking medical appointments online, but ADoctor exceeded my expectations. The process was straightforward, and the customer support team was incredibly helpful when I had a question. I highly recommend ADoctor to anyone seeking quality healthcare services with ease"},"es":{"comment":"Ten\\u00eda mis reservas sobre la reserva de citas m\\u00e9dicas en l\\u00ednea, pero ADoctor super\\u00f3 mis expectativas. El proceso fue sencillo y el equipo de atenci\\u00f3n al cliente fue incre\\u00edblemente \\u00fatil cuando ten\\u00eda una pregunta. Recomiendo encarecidamente ADoctor a cualquier persona que busque servicios de atenci\\u00f3n m\\u00e9dica de calidad con facilidad."},"ar":{"comment":"\\u0643\\u0627\\u0646\\u062a \\u0644\\u062f\\u064a \\u062a\\u062d\\u0641\\u0638\\u0627\\u062a \\u0628\\u0634\\u0623\\u0646 \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a\\u060c \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0641\\u0627\\u0642 \\u062a\\u0648\\u0642\\u0639\\u0627\\u062a\\u064a. \\u0643\\u0627\\u0646\\u062a \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0648\\u0627\\u0636\\u062d\\u0629\\u060c \\u0648\\u0643\\u0627\\u0646 \\u0641\\u0631\\u064a\\u0642 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0645\\u0641\\u064a\\u062f\\u064b\\u0627 \\u0644\\u0644\\u063a\\u0627\\u064a\\u0629 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a \\u0633\\u0624\\u0627\\u0644. \\u0623\\u0648\\u0635\\u064a \\u0628\\u0634\\u062f\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 ADoctor \\u0644\\u0623\\u064a \\u0634\\u062e\\u0635 \\u064a\\u0628\\u062d\\u062b \\u0639\\u0646 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0631\\u0639\\u0627\\u064a\\u0629 \\u0635\\u062d\\u064a\\u0629 \\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629"}},"id":"648ea7dd1c1c6","image":"seeder\\/test2.webp","name":"Emily Johnson","designation":"Doctor","rating":"5","created_at":"2023-06-18T06:44:45.123737Z"},"64c24664ab5d6":{"language":{"en":{"comment":"I can\'t thank ADoctor enough for the convenience it offers. Being able to access my medical records online has been a game-changer for managing my health. It\'s such a relief to have all my information in one place and easily accessible whenever I need it. ADoctor truly puts the patient\'s needs first."},"es":{"comment":"No puedo agradecer lo suficiente a ADoctor por la comodidad que ofrece. Poder acceder a mis registros m\\u00e9dicos en l\\u00ednea ha cambiado las reglas del juego para administrar mi salud. Es un gran alivio tener toda mi informaci\\u00f3n en un solo lugar y f\\u00e1cilmente accesible cuando la necesito. ADoctor realmente pone las necesidades del paciente primero."},"ar":{"comment":"\\u0644\\u0627 \\u0623\\u0633\\u062a\\u0637\\u064a\\u0639 \\u0623\\u0646 \\u0623\\u0634\\u0643\\u0631 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0628\\u0645\\u0627 \\u0641\\u064a\\u0647 \\u0627\\u0644\\u0643\\u0641\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0642\\u062f\\u0645\\u0647\\u0627. \\u0625\\u0646 \\u0627\\u0644\\u0642\\u062f\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0633\\u062c\\u0644\\u0627\\u062a\\u064a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0642\\u062f \\u063a\\u064a\\u0631\\u062a \\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u0644\\u0639\\u0628\\u0629 \\u0641\\u064a\\u0645\\u0627 \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0635\\u062d\\u062a\\u064a. \\u0625\\u0646\\u0647 \\u0644\\u0645\\u0646 \\u062f\\u0648\\u0627\\u0639\\u064a \\u0627\\u0644\\u0631\\u0627\\u062d\\u0629 \\u0623\\u0646 \\u0623\\u062d\\u062a\\u0641\\u0638 \\u0628\\u062c\\u0645\\u064a\\u0639 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u064a \\u0641\\u064a \\u0645\\u0643\\u0627\\u0646 \\u0648\\u0627\\u062d\\u062f \\u0648\\u064a\\u0645\\u0643\\u0646 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u064a\\u0647\\u0627 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u0623\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u064a\\u0647\\u0627. \\u064a\\u0636\\u0639 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u0645\\u0631\\u064a\\u0636 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0642\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0648\\u0644."}},"id":"64c24664ab5d6","image":"seeder\\/test3.webp","name":"Michael Davis","designation":"Psychiatrist","rating":"4","created_at":"2023-07-27T10:26:44.726208Z"},"64c246c0b261a":{"language":{"en":{"comment":"ADoctor\'s platform is so intuitive and well-designed. The ability to choose from various hospital branches and specialties gave me the freedom to select a doctor that best suited my medical needs. The entire process, from booking to visiting the doctor, was seamless and efficient. I\'m impressed with the level of service they provide."},"es":{"comment":"La plataforma de ADoctor es muy intuitiva y est\\u00e1 bien dise\\u00f1ada. La posibilidad de elegir entre varias ramas y especialidades del hospital me dio la libertad de seleccionar el m\\u00e9dico que mejor se adaptaba a mis necesidades m\\u00e9dicas. Todo el proceso, desde la reserva hasta la visita al m\\u00e9dico, fue fluido y eficiente. Estoy impresionado con el nivel de servicio que brindan."},"ar":{"comment":"\\u0645\\u0646\\u0635\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0628\\u062f\\u064a\\u0647\\u064a\\u0629 \\u0644\\u0644\\u063a\\u0627\\u064a\\u0629 \\u0648\\u0645\\u0635\\u0645\\u0645\\u0629 \\u0628\\u0634\\u0643\\u0644 \\u062c\\u064a\\u062f. \\u0644\\u0642\\u062f \\u0645\\u0646\\u062d\\u062a\\u0646\\u064a \\u0627\\u0644\\u0642\\u062f\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0645\\u0646 \\u0628\\u064a\\u0646 \\u0641\\u0631\\u0648\\u0639 \\u0648\\u062a\\u062e\\u0635\\u0635\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u0634\\u0641\\u0649 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0641\\u064a \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0646\\u0627\\u0633\\u0628 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a\\u064a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629. \\u0643\\u0627\\u0646\\u062a \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0628\\u0631\\u0645\\u062a\\u0647\\u0627\\u060c \\u0628\\u062f\\u0621\\u064b\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u062d\\u062c\\u0632 \\u0648\\u062d\\u062a\\u0649 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628\\u060c \\u0633\\u0644\\u0633\\u0629 \\u0648\\u0641\\u0639\\u0627\\u0644\\u0629. \\u0623\\u0646\\u0627 \\u0645\\u0639\\u062c\\u0628 \\u0628\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0642\\u062f\\u0645\\u0648\\u0646\\u0647\\u0627."}},"id":"64c246c0b261a","image":"seeder\\/test4.webp","name":"Sarah Thompson","designation":"Surgeon","rating":"5","created_at":"2023-07-27T10:28:16.746524Z"},"64c246f7b88c9":{"language":{"en":{"comment":"I\'m a busy professional, and ADoctor has been a lifesaver for me. The appointment reminders and easy rescheduling options have saved me from missing important appointments. It\'s the little things like these that make ADoctor stand out from the rest. Highly recommended!"},"es":{"comment":"Soy un profesional ocupado y ADoctor me ha salvado la vida. Los recordatorios de citas y las sencillas opciones de reprogramaci\\u00f3n me han evitado perder citas importantes. Son las peque\\u00f1as cosas como estas las que hacen que ADoctor se destaque del resto. \\u00a1Muy recomendable!"},"ar":{"comment":"\\u0623\\u0646\\u0627 \\u0645\\u062d\\u062a\\u0631\\u0641 \\u0645\\u0634\\u063a\\u0648\\u0644\\u060c \\u0648\\u0643\\u0627\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0647\\u0648 \\u0627\\u0644\\u0645\\u0646\\u0642\\u0630 \\u0628\\u0627\\u0644\\u0646\\u0633\\u0628\\u0629 \\u0644\\u064a. \\u0644\\u0642\\u062f \\u0623\\u0646\\u0642\\u0630\\u062a\\u0646\\u064a \\u062a\\u0630\\u0643\\u064a\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0648\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u062c\\u062f\\u0648\\u0644\\u0629 \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0645\\u0646 \\u0641\\u0642\\u062f\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0627\\u0644\\u0645\\u0647\\u0645\\u0629. \\u0625\\u0646\\u0647\\u0627 \\u0627\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631\\u0629 \\u0645\\u062b\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062c\\u0639\\u0644 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0645\\u062a\\u0645\\u064a\\u0632\\u064b\\u0627 \\u0639\\u0646 \\u0627\\u0644\\u0628\\u0627\\u0642\\u064a. \\u064a\\u0646\\u0635\\u062d \\u0628\\u0647 \\u0628\\u0634\\u062f\\u0647!"}},"id":"64c246f7b88c9","image":"seeder\\/test5.webp","name":"David Anderson","designation":"Pediatrician","rating":"4","created_at":"2023-07-27T10:29:11.770755Z"},"64c24731eb199":{"language":{"en":{"comment":"Using ADoctor has been a breath of fresh air in the healthcare industry. The platform\'s emphasis on transparency and choice empowers patients to take control of their health. I\'m grateful for the exceptional care I\'ve received from the doctors I found through ADoctor."},"es":{"comment":"Usar ADoctor ha sido una bocanada de aire fresco en la industria de la salud. El \\u00e9nfasis de la plataforma en la transparencia y la elecci\\u00f3n permite a los pacientes tomar el control de su salud. Estoy agradecido por la atenci\\u00f3n excepcional que he recibido de los m\\u00e9dicos que encontr\\u00e9 a trav\\u00e9s de ADoctor."},"ar":{"comment":"\\u0644\\u0642\\u062f \\u0643\\u0627\\u0646 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0628\\u0645\\u062b\\u0627\\u0628\\u0629 \\u0646\\u0633\\u0645\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0647\\u0648\\u0627\\u0621 \\u0627\\u0644\\u0646\\u0642\\u064a \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629. \\u0625\\u0646 \\u062a\\u0631\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u064a\\u0645\\u0643\\u0651\\u0646 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0645\\u0646 \\u0627\\u0644\\u0633\\u064a\\u0637\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u0635\\u062d\\u062a\\u0647\\u0645. \\u0623\\u0646\\u0627 \\u0645\\u0645\\u062a\\u0646 \\u0644\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u0626\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0644\\u0642\\u064a\\u062a\\u0647\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0648\\u062c\\u062f\\u062a\\u0647\\u0645 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628."}},"id":"64c24731eb199","image":"seeder\\/test6.webp","name":"Jessica Lee","designation":"Endocrinologist","rating":"4","created_at":"2023-07-27T10:30:09.979760Z"},"64c247714303e":{"language":{"en":{"comment":"I was skeptical about online doctor booking services, but ADoctor proved me wrong. The platform\'s extensive range of medical specialties and easy-to-navigate interface make finding the right doctor a breeze. I appreciate how ADoctor values user feedback and continually improves its services."},"es":{"comment":"Era esc\\u00e9ptico acerca de los servicios de reserva de m\\u00e9dicos en l\\u00ednea, pero ADoctor demostr\\u00f3 que estaba equivocado. La amplia gama de especialidades m\\u00e9dicas de la plataforma y la interfaz f\\u00e1cil de navegar hacen que encontrar al m\\u00e9dico adecuado sea pan comido. Aprecio c\\u00f3mo ADoctor valora los comentarios de los usuarios y mejora continuamente sus servicios."},"ar":{"comment":"\\u0644\\u0642\\u062f \\u0643\\u0646\\u062a \\u0645\\u062a\\u0634\\u0643\\u0643\\u064b\\u0627 \\u0628\\u0634\\u0623\\u0646 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a\\u060c \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0623\\u062b\\u0628\\u062a \\u0623\\u0646\\u0646\\u064a \\u0645\\u062e\\u0637\\u0626. \\u0625\\u0646 \\u0627\\u0644\\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0627\\u0644\\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u062e\\u0635\\u0635\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0648\\u0627\\u0644\\u0648\\u0627\\u062c\\u0647\\u0629 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0646\\u0642\\u0644 \\u062a\\u062c\\u0639\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0633\\u0628 \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0633\\u0647\\u0644\\u0627\\u064b. \\u0625\\u0646\\u0646\\u064a \\u0623\\u0642\\u062f\\u0631 \\u0645\\u062f\\u0649 \\u062a\\u0642\\u062f\\u064a\\u0631 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0644\\u062a\\u0639\\u0644\\u064a\\u0642\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0648\\u062a\\u062d\\u0633\\u064a\\u0646 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0647 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631."}},"id":"64c247714303e","image":"seeder\\/test7.webp","name":"Ryan Clark","designation":"Anesthesiologist","rating":"4","created_at":"2023-07-27T10:31:13.290108Z"},"64c247aea643c":{"language":{"en":{"comment":"ADoctor is the future of healthcare booking. I no longer have to wait in long queues or struggle with phone calls to schedule appointments. It\'s a seamless experience that has simplified my life. I\'ve recommended ADoctor to all my friends and family."},"es":{"comment":"ADoctor es el futuro de la reserva de atenci\\u00f3n m\\u00e9dica. Ya no tengo que esperar en largas colas ni luchar con llamadas telef\\u00f3nicas para programar citas. Es una experiencia perfecta que ha simplificado mi vida. He recomendado ADoctor a todos mis amigos y familiares."},"ar":{"comment":"\\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0647\\u0648 \\u0645\\u0633\\u062a\\u0642\\u0628\\u0644 \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629. \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0639\\u0644\\u064a \\u0627\\u0644\\u0627\\u0646\\u062a\\u0638\\u0627\\u0631 \\u0641\\u064a \\u0637\\u0648\\u0627\\u0628\\u064a\\u0631 \\u0637\\u0648\\u064a\\u0644\\u0629 \\u0623\\u0648 \\u0645\\u0648\\u0627\\u062c\\u0647\\u0629 \\u0627\\u0644\\u0645\\u0643\\u0627\\u0644\\u0645\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641\\u064a\\u0629 \\u0644\\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f. \\u0625\\u0646\\u0647\\u0627 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0633\\u0644\\u0633\\u0629 \\u0633\\u0647\\u0651\\u0644\\u062a \\u062d\\u064a\\u0627\\u062a\\u064a. \\u0644\\u0642\\u062f \\u0623\\u0648\\u0635\\u064a\\u062a \\u0628\\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0635\\u062f\\u0642\\u0627\\u0626\\u064a \\u0648\\u0639\\u0627\\u0626\\u0644\\u062a\\u064a."}},"id":"64c247aea643c","image":"seeder\\/test8.webp","name":"Karen Martinez","designation":"Pediatrician","rating":"4","created_at":"2023-07-27T10:32:14.701198Z"},"64c2482e8c255":{"language":{"en":{"comment":"As a parent, booking appointments for my children was always a challenge. ADoctor\'s feature to book appointments for family members made it so much easier for me. Now I can take care of my family\'s health without any stress. Thank you, ADoctor!"},"es":{"comment":"Como padre, reservar citas para mis hijos siempre fue un desaf\\u00edo. La caracter\\u00edstica de ADoctor para reservar citas para miembros de la familia me lo hizo mucho m\\u00e1s f\\u00e1cil. Ahora puedo cuidar la salud de mi familia sin estr\\u00e9s. \\u00a1Gracias, doctora!"},"ar":{"comment":"\\u0643\\u0648\\u0627\\u0644\\u062f\\u060c \\u0643\\u0627\\u0646 \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0644\\u0623\\u0637\\u0641\\u0627\\u0644\\u064a \\u064a\\u0645\\u062b\\u0644 \\u062a\\u062d\\u062f\\u064a\\u064b\\u0627 \\u062f\\u0627\\u0626\\u0645\\u064b\\u0627. \\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0644\\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u062c\\u0639\\u0644\\u062a \\u0627\\u0644\\u0623\\u0645\\u0631 \\u0623\\u0633\\u0647\\u0644 \\u0628\\u0643\\u062b\\u064a\\u0631 \\u0628\\u0627\\u0644\\u0646\\u0633\\u0628\\u0629 \\u0644\\u064a. \\u0627\\u0644\\u0622\\u0646 \\u0623\\u0633\\u062a\\u0637\\u064a\\u0639 \\u0623\\u0646 \\u0623\\u0639\\u062a\\u0646\\u064a \\u0628\\u0635\\u062d\\u0629 \\u0639\\u0627\\u0626\\u0644\\u062a\\u064a \\u062f\\u0648\\u0646 \\u0623\\u064a \\u0636\\u063a\\u0648\\u0637. \\u0634\\u0643\\u0631\\u0627 \\u0644\\u0643 \\u062f\\u0643\\u062a\\u0648\\u0631!"}},"id":"64c2482e8c255","image":"seeder\\/test9.webp","name":"James Johnson","designation":"General practitioner","rating":"4","created_at":"2023-07-27T10:34:22.592051Z"},"64c24861e20e1":{"language":{"en":{"comment":"I\'m grateful for ADoctor\'s dedication to patient privacy and data security. I was hesitant about sharing my medical records online, but ADoctor\'s robust security measures gave me peace of mind. It\'s refreshing to see a platform that genuinely cares about its users."},"es":{"comment":"Estoy agradecido por la dedicaci\\u00f3n de ADoctor a la privacidad del paciente y la seguridad de los datos. Ten\\u00eda dudas sobre compartir mis registros m\\u00e9dicos en l\\u00ednea, pero las s\\u00f3lidas medidas de seguridad de ADoctor me dieron tranquilidad. Es refrescante ver una plataforma que realmente se preocupa por sus usuarios."},"ar":{"comment":"\\u0623\\u0646\\u0627 \\u0645\\u0645\\u062a\\u0646 \\u0644\\u062a\\u0641\\u0627\\u0646\\u064a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0631\\u064a\\u0636 \\u0648\\u0623\\u0645\\u0646 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a. \\u0644\\u0642\\u062f \\u0643\\u0646\\u062a \\u0645\\u062a\\u0631\\u062f\\u062f\\u064b\\u0627 \\u0628\\u0634\\u0623\\u0646 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0633\\u062c\\u0644\\u0627\\u062a\\u064a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a\\u060c \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0623\\u0645\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0635\\u0627\\u0631\\u0645\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0627\\u062a\\u062e\\u0630\\u0647\\u0627 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0623\\u0639\\u0637\\u062a\\u0646\\u064a \\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0628\\u0627\\u0644. \\u0625\\u0646\\u0647 \\u0623\\u0645\\u0631 \\u0645\\u0646\\u0639\\u0634 \\u0623\\u0646 \\u062a\\u0631\\u0649 \\u0645\\u0646\\u0635\\u0629 \\u062a\\u0647\\u062a\\u0645 \\u062d\\u0642\\u064b\\u0627 \\u0628\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0647\\u0627."}},"id":"64c24861e20e1","image":"seeder\\/test10.webp","name":"Emma Williams","designation":"Internal medicine","rating":"4","created_at":"2023-07-27T10:35:13.952557Z"}}}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:42:47','updated_at' => '2023-09-14 10:39:10'),
          array('key' => 'how-its-work','value' => '{"language":{"en":{"title":"How It\'s Works","heading":"A user-friendly 4-step process that makes booking appointments","sub_heading":"Seamlessly book your hospital appointments online, saving time and reducing the hassle of traditional appointment booking methods."},"es":{"title":"C\\u00f3mo funciona","heading":"Un proceso de 4 pasos f\\u00e1cil de usar que hace citas de reserva","sub_heading":"Reserve sin problemas sus citas en el hospital en l\\u00ednea, ahorre tiempo y reduzca las molestias de los m\\u00e9todos tradicionales de reserva de citas."},"ar":{"title":"\\u0643\\u064a\\u0641 \\u064a\\u0639\\u0645\\u0644","heading":"\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0643\\u0648\\u0646\\u0629 \\u0645\\u0646 4 \\u062e\\u0637\\u0648\\u0627\\u062a \\u062a\\u0642\\u0648\\u0645 \\u0628\\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f","sub_heading":"\\u0627\\u062d\\u062c\\u0632 \\u0645\\u0648\\u0627\\u0639\\u064a\\u062f\\u0643 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0633\\u062a\\u0634\\u0641\\u0649 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0648\\u0641\\u0631 \\u0627\\u0644\\u0648\\u0642\\u062a \\u0648\\u064a\\u0642\\u0644\\u0644 \\u0645\\u0646 \\u0645\\u062a\\u0627\\u0639\\u0628 \\u0637\\u0631\\u0642 \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0627\\u0644\\u062a\\u0642\\u0644\\u064a\\u062f\\u064a\\u0629."}},"items":{"648ea82374a23":{"language":{"en":{"item_title":"Register an Account"},"es":{"item_title":"Registrar una cuenta"},"ar":{"item_title":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u062d\\u0633\\u0627\\u0628"}},"id":"648ea82374a23","icon":"fas fa-user-edit"},"648ea835b9e91":{"language":{"en":{"item_title":"Pick a Branch"},"es":{"item_title":"Elige una sucursal"},"ar":{"item_title":"\\u0627\\u062e\\u062a\\u0631 \\u0641\\u0631\\u0639\\u0627"}},"id":"648ea835b9e91","icon":"fas fa-code-branch"},"648ea84994dc4":{"language":{"en":{"item_title":"Select Your Doctor"},"es":{"item_title":"Seleccione su m\\u00e9dico"},"ar":{"item_title":"\\u0627\\u062e\\u062a\\u0631 \\u0637\\u0628\\u064a\\u0628\\u0643"}},"id":"648ea84994dc4","icon":"fas fa-stethoscope"},"648ea8658e339":{"language":{"en":{"item_title":"Book Your Appointment"},"es":{"item_title":"Reserve su cita"},"ar":{"item_title":"\\u0627\\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f\\u0643"}},"id":"648ea8658e339","icon":"fas fa-check"}}}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:45:19','updated_at' => '2023-09-14 10:41:40'),
          array('key' => 'web-journal','value' => '{"language":{"en":{"title":"Web Journal","heading":"Announcement About Health Initiatives","sub_heading":"It\'s cover a wide range of topics, catering to different interests and aspects of healthcare and well-being."},"es":{"title":"revista web","heading":"Anuncio sobre iniciativas de salud","sub_heading":"Cubre una amplia gama de temas, atendiendo a diferentes intereses y aspectos de la atenci\\u00f3n m\\u00e9dica y el bienestar."},"ar":{"title":"\\u0645\\u062c\\u0644\\u0629 \\u0627\\u0644\\u0648\\u064a\\u0628","heading":"\\u0625\\u0639\\u0644\\u0627\\u0646 \\u062d\\u0648\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0627\\u062f\\u0631\\u0627\\u062a \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629","sub_heading":"\\u0625\\u0646\\u0647 \\u064a\\u063a\\u0637\\u064a \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0636\\u064a\\u0639\\u060c \\u0648\\u064a\\u0644\\u0628\\u064a \\u0627\\u0647\\u062a\\u0645\\u0627\\u0645\\u0627\\u062a \\u0648\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0631\\u0641\\u0627\\u0647\\u064a\\u0629."}}}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:47:29','updated_at' => '2023-09-14 10:42:40'),
          array('key' => 'footer-section','value' => '{"footer":{"language":{"en":{"description":"online based doctors\' appointment service with the facility of an electronic personal health record system."},"es":{"description":"servicio de citas m\\u00e9dicas basado en l\\u00ednea con la facilidad de un sistema de registro de salud personal electr\\u00f3nico."},"ar":{"description":"\\u062e\\u062f\\u0645\\u0629 \\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f \\u0644\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0645\\u0639 \\u0646\\u0638\\u0627\\u0645 \\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0644\\u0644\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629."}},"image":"seeder\\/web_logo.png"},"social_links":[{"icon":"fab fa-facebook","link":"https:\\/\\/www.facebook.com\\/"},{"icon":"fab fa-twitter","link":"https:\\/\\/www.twitter.com\\/"},{"icon":"fab fa-instagram","link":"https:\\/\\/www.instagram.com\\/"}],"communication_links":[{"communication_icon":"fas fa-phone-volume","communication_link":"808 - 111 - 9999"},{"communication_icon":"far fa-envelope","communication_link":"demo@example.com"},{"communication_icon":"far fa-user","communication_link":"demo@support.com"}]}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:52:54','updated_at' => '2023-09-14 10:54:13'),
          array('key' => 'news-letter-section','value' => '{"language":{"en":{"title":"Newsletter","description":"Stay connected with us for regular updates by providing your name and email address"},"es":{"title":"Boletin informativo","description":"Mant\\u00e9ngase conectado con nosotros para recibir actualizaciones peri\\u00f3dicas proporcionando su nombre y direcci\\u00f3n de correo electr\\u00f3nico"},"ar":{"title":"\\u0627\\u0644\\u0646\\u0634\\u0631\\u0629 \\u0627\\u0644\\u0625\\u062e\\u0628\\u0627\\u0631\\u064a\\u0629","description":"\\u0627\\u0628\\u0642 \\u0639\\u0644\\u0649 \\u0627\\u062a\\u0635\\u0627\\u0644 \\u0645\\u0639\\u0646\\u0627 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u062f\\u064a\\u062b\\u0627\\u062a \\u0645\\u0646\\u062a\\u0638\\u0645\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0633\\u0645\\u0643 \\u0648\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0628\\u0631\\u064a\\u062f\\u0643 \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a"}}}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:53:12','updated_at' => '2023-09-14 10:54:55'),
          array('key' => 'contact-section','value' => '{"language":{"en":{"title":"Information","description":"Please use the feedback form to get in touch with us if you have any inquiries or requests. Within a few hours, the administrator will respond to your inquiry"},"es":{"title":"Informaci\\u00f3n","description":"Utilice el formulario de comentarios para ponerse en contacto con nosotros si tiene alguna consulta o solicitud. En unas horas, el administrador responder\\u00e1 a su consulta"},"ar":{"title":"\\u0645\\u0639\\u0644\\u0648\\u0645\\u0629","description":"\\u064a\\u0631\\u062c\\u0649 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0646\\u0645\\u0648\\u0630\\u062c \\u0627\\u0644\\u0645\\u0644\\u0627\\u062d\\u0638\\u0627\\u062a \\u0644\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0643 \\u0623\\u064a \\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a \\u0623\\u0648 \\u0637\\u0644\\u0628\\u0627\\u062a. \\u0648\\u0641\\u064a \\u063a\\u0636\\u0648\\u0646 \\u0633\\u0627\\u0639\\u0627\\u062a \\u0642\\u0644\\u064a\\u0644\\u0629\\u060c \\u0633\\u0648\\u0641 \\u064a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644 \\u0628\\u0627\\u0644\\u0631\\u062f \\u0639\\u0644\\u0649 \\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0643"}},"phone":"+03601 885399","address":"20-22 Wenlock Road, London, England, N1 7GU","email":"support@example.com"}','status' => '1','serialize' => NULL,'created_at' => '2023-06-18 06:54:00','updated_at' => '2023-09-14 10:55:31'),
          array('key' => 'login-section','value' => '{"language":{"en":{"title":"Log in and Stay Connected","description":"Log in and Stay Connected Our secure login process ensures the confidentiality of your information. Log in today and stay connected to your finances, anytime and anywhere."},"es":{"title":"Inicie sesi\\u00f3n y mant\\u00e9ngase conectado","description":"Inicie sesi\\u00f3n y mant\\u00e9ngase conectado Nuestro proceso de inicio de sesi\\u00f3n seguro garantiza la confidencialidad de su informaci\\u00f3n. Inicie sesi\\u00f3n hoy y mant\\u00e9ngase conectado con sus finanzas, en cualquier momento y en cualquier lugar."},"ar":{"title":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0648\\u0627\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u0627\\u062a\\u0635\\u0627\\u0644","description":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0648\\u0627\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u0627\\u062a\\u0635\\u0627\\u0644 \\u062a\\u0636\\u0645\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0633\\u0631\\u064a\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643. \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0648\\u0627\\u0628\\u0642 \\u0639\\u0644\\u0649 \\u0627\\u062a\\u0635\\u0627\\u0644 \\u0628\\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0641\\u064a \\u0623\\u064a \\u0648\\u0642\\u062a \\u0648\\u0641\\u064a \\u0623\\u064a \\u0645\\u0643\\u0627\\u0646."}}}','status' => '1','serialize' => NULL,'created_at' => '2023-11-21 04:40:15','updated_at' => '2023-11-21 04:41:04'),
          array('key' => 'register-section','value' => '{"language":{"en":{"title":"Register for an Account Today","description":"Become a part of our community by registering for an account today. Enjoy a range of benefits and features tailored to meet your needs. Our registration page makes it easy to create your account, providing a seamless and user-friendly experience."},"es":{"title":"Register for an Account Today","description":"Convi\\u00e9rtase en parte de nuestra comunidad registr\\u00e1ndose para obtener una cuenta hoy. Disfrute de una variedad de beneficios y caracter\\u00edsticas dise\\u00f1adas para satisfacer sus necesidades. Nuestra p\\u00e1gina de registro facilita la creaci\\u00f3n de su cuenta, brindando una experiencia fluida y f\\u00e1cil de usar."},"ar":{"title":"\\u0633\\u062c\\u0644 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u064a\\u0648\\u0645","description":"\\u0643\\u0646 \\u062c\\u0632\\u0621\\u064b\\u0627 \\u0645\\u0646 \\u0645\\u062c\\u062a\\u0645\\u0639\\u0646\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u064a\\u0648\\u0645. \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0632\\u0627\\u064a\\u0627 \\u0648\\u0627\\u0644\\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u062e\\u0635\\u064a\\u0635\\u064b\\u0627 \\u0644\\u062a\\u0644\\u0628\\u064a\\u0629 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a\\u0643. \\u062a\\u0633\\u0647\\u0644 \\u0635\\u0641\\u062d\\u0629 \\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0646\\u0627 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0648\\u0641\\u0631 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0633\\u0644\\u0633\\u0629 \\u0648\\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645."}}}','status' => '1','serialize' => NULL,'created_at' => '2023-11-21 06:00:16','updated_at' => '2023-11-21 06:00:16')
        
        ); 
        SiteSections::upsert($data,['key'],[]);

        $journals = array(
            array('slug' => 'fugiat-possimus-eliwe','data' => '{"language":{"en":{"title":"Empowering Patients with Information","icon":"fab fa-acquisitions-incorporated","description":"<p>One of the cornerstones of ADoctor\'s approach is transparency. Patients can access detailed profiles of doctors, complete with their specialties, qualifications, and patient reviews. This wealth of information empowers patients to make informed decisions about their healthcare, ensuring they choose the right doctor to meet their unique needs.<\\/p>","tags":["Patients"]},"es":{"title":"Empoderar a las pacientes con informaci\\u00f3n","icon":"fab fa-acquisitions-incorporated","description":"<p>Uno de los pilares del enfoque de ADoctor es la transparencia. Los pacientes pueden acceder a perfiles detallados de m\\u00e9dicos, completos con sus especialidades, calificaciones y revisiones de pacientes. Esta gran cantidad de informaci\\u00f3n permite a los pacientes tomar decisiones informadas sobre su atenci\\u00f3n m\\u00e9dica, asegurando que elijan al m\\u00e9dico adecuado para satisfacer sus necesidades \\u00fanicas.<\\/p>","tags":["pacientes"]},"ar":{"title":"\\u062a\\u0645\\u0643\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0628\\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a","icon":"fab fa-acquisitions-incorporated","description":"<p>\\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0647\\u064a \\u0625\\u062d\\u062f\\u0649 \\u0627\\u0644\\u0631\\u0643\\u0627\\u0626\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a\\u0629 \\u0644\\u0646\\u0647\\u062c \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628. \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0644\\u0641\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0641\\u0635\\u064a\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621\\u060c \\u0645\\u0639 \\u0627\\u0633\\u062a\\u0643\\u0645\\u0627\\u0644 \\u062a\\u062e\\u0635\\u0635\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0645\\u0624\\u0647\\u0644\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0645\\u0631\\u0627\\u062c\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649. \\u062a\\u0645\\u0643\\u0646 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062b\\u0631\\u0648\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0645\\u0646 \\u0627\\u062a\\u062e\\u0627\\u0630 \\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0645\\u0633\\u062a\\u0646\\u064a\\u0631\\u0629 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0633\\u0628 \\u0644\\u062a\\u0644\\u0628\\u064a\\u0629 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0631\\u064a\\u062f\\u0629.<\\/p>","tags":["\\u0645\\u0631\\u0636\\u0649"]}},"image":"seeder\\/blog1.webp"}','status' => '1','created_at' => '2023-07-19 09:41:33','updated_at' => '2023-09-14 10:53:37'),
            array('slug' => 'fugiat-possimus-elides','data' => '{"language":{"en":{"title":"Streamlining the Appointment Process","icon":"fab fa-affiliatetheme","description":"<p>Gone are the days of waiting for hours at the hospital or endlessly trying to get through to busy receptionists to book an appointment. ADoctor\'s user-friendly platform has streamlined the entire appointment process. With just a few clicks, patients can create an account, browse through a wide selection of doctors, and book an appointment that suits their schedule. It\'s simple, efficient, and designed to cater to the modern patient\'s busy lifestyle.<br>&nbsp;<\\/p>","tags":["hospital"]},"es":{"title":"Agilizaci\\u00f3n del proceso de citas","icon":"fab fa-affiliatetheme","description":"<p>Atr\\u00e1s quedaron los d\\u00edas de esperar durante horas en el hospital o de tratar interminablemente de comunicarse con recepcionistas ocupados para programar una cita. La plataforma f\\u00e1cil de usar de ADoctor ha simplificado todo el proceso de citas. Con solo unos pocos clics, los pacientes pueden crear una cuenta, navegar a trav\\u00e9s de una amplia selecci\\u00f3n de m\\u00e9dicos y reservar una cita que se adapte a su horario. Es simple, eficiente y est\\u00e1 dise\\u00f1ado para satisfacer el ajetreado estilo de vida del paciente moderno.<\\/p>","tags":["quedaron"]},"ar":{"title":"\\u062a\\u0628\\u0633\\u064a\\u0637 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0639\\u064a\\u064a\\u0646","icon":"fab fa-affiliatetheme","description":"<p>\\u0644\\u0642\\u062f \\u0648\\u0644\\u062a \\u0623\\u064a\\u0627\\u0645 \\u0627\\u0644\\u0627\\u0646\\u062a\\u0638\\u0627\\u0631 \\u0644\\u0633\\u0627\\u0639\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0645\\u0633\\u062a\\u0634\\u0641\\u0649 \\u0623\\u0648 \\u0645\\u062d\\u0627\\u0648\\u0644\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u0648\\u0638\\u0641\\u064a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0634\\u063a\\u0648\\u0644\\u064a\\u0646 \\u0644\\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f. \\u0644\\u0642\\u062f \\u0642\\u0627\\u0645\\u062a \\u0645\\u0646\\u0635\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u062a\\u0628\\u0633\\u064a\\u0637 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0639\\u064a\\u064a\\u0646 \\u0628\\u0623\\u0643\\u0645\\u0644\\u0647\\u0627. \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0628\\u0636\\u0639 \\u0646\\u0642\\u0631\\u0627\\u062a \\u0641\\u0642\\u0637\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628\\u060c \\u0648\\u062a\\u0635\\u0641\\u062d \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621\\u060c \\u0648\\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f \\u064a\\u0646\\u0627\\u0633\\u0628 \\u062c\\u062f\\u0648\\u0644\\u0647\\u0645 \\u0627\\u0644\\u0632\\u0645\\u0646\\u064a. \\u0625\\u0646\\u0647\\u0627 \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0648\\u0641\\u0639\\u0627\\u0644\\u0629 \\u0648\\u0645\\u0635\\u0645\\u0645\\u0629 \\u0644\\u062a\\u0644\\u0628\\u064a\\u0629 \\u0646\\u0645\\u0637 \\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u0631\\u064a\\u0636 \\u0627\\u0644\\u062d\\u062f\\u064a\\u062b \\u0627\\u0644\\u0645\\u0632\\u062f\\u062d\\u0645.<\\/p>","tags":["\\u0645\\u0633\\u062a\\u0634\\u0641\\u0649"]}},"image":"seeder\\/blog2.webp"}','status' => '1','created_at' => '2023-07-19 09:41:33','updated_at' => '2023-09-14 10:52:28'),
            array('slug' => 'fugiat-possimus-eli-ecf','data' => '{"language":{"en":{"title":"The Future of Healthcare: Empowering Patients with ADoctor","icon":"fas fa-stethoscope","description":"<p>In the ever-evolving landscape of healthcare, technology continues to play a vital role in transforming the patient experience. One platform that stands out in this digital revolution is ADoctor. By merging cutting-edge technology with the noble mission of providing accessible healthcare, ADoctor is reshaping the way patients interact with the medical world.<br>&nbsp;<\\/p>","tags":["Health-Care"]},"es":{"title":"El futuro de la atenci\\u00f3n m\\u00e9dica: empoderar a las pacientes con ADoctor","icon":"fas fa-ankh","description":"<p>En el panorama en constante evoluci\\u00f3n de la atenci\\u00f3n m\\u00e9dica, la tecnolog\\u00eda contin\\u00faa desempe\\u00f1ando un papel vital en la transformaci\\u00f3n de la experiencia del paciente. Una plataforma que destaca en esta revoluci\\u00f3n digital es ADoctor. Al fusionar tecnolog\\u00eda de punta con la noble misi\\u00f3n de brindar atenci\\u00f3n m\\u00e9dica accesible, ADoctor est\\u00e1 remodelando la forma en que los pacientes interact\\u00faan con el mundo m\\u00e9dico.<\\/p>","tags":["panorama"]},"ar":{"title":"\\u0645\\u0633\\u062a\\u0642\\u0628\\u0644 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629: \\u062a\\u0645\\u0643\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0645\\u0639 \\u0637\\u0628\\u064a\\u0628","icon":"fas fa-stethoscope","description":"<p>\\u0641\\u064a \\u0645\\u0634\\u0647\\u062f \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631\\u060c \\u062a\\u0633\\u062a\\u0645\\u0631 \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627 \\u0641\\u064a \\u0644\\u0639\\u0628 \\u062f\\u0648\\u0631 \\u062d\\u064a\\u0648\\u064a \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0645\\u0631\\u064a\\u0636. \\u0625\\u062d\\u062f\\u0649 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0628\\u0631\\u0632 \\u0641\\u064a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062b\\u0648\\u0631\\u0629 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629 \\u0647\\u064a \\u0645\\u0646\\u0635\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628. \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062f\\u0645\\u062c \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0647\\u0645\\u0629 \\u0627\\u0644\\u0646\\u0628\\u064a\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u062a\\u0648\\u0641\\u064a\\u0631 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u064a\\u0647\\u0627\\u060c \\u064a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0628\\u0625\\u0639\\u0627\\u062f\\u0629 \\u062a\\u0634\\u0643\\u064a\\u0644 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u062a\\u0641\\u0627\\u0639\\u0644 \\u0628\\u0647\\u0627 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0645\\u0639 \\u0639\\u0627\\u0644\\u0645 \\u0627\\u0644\\u0637\\u0628.<\\/p>","tags":["\\u0627\\u0644\\u0631\\u0639\\u0627\\u0649\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629"]}},"image":"seeder\\/blog3.webp"}','status' => '1','created_at' => '2023-07-19 09:41:33','updated_at' => '2023-09-14 10:51:12'),
            array('slug' => 'a-diverse-network-of-medical-specialties','data' => '{"language":{"en":{"title":"A Diverse Network of Medical Specialties","icon":"fas fa-archive","description":"<p>ADoctor\'s network of hospital branches spans various medical specialties, offering patients a diverse range of healthcare services. Whether you\'re seeking routine check-ups, specialized care, or expert advice, ADoctor connects you with a wide array of medical professionals, all under one roof.<br>&nbsp;<\\/p>","tags":["medical"]},"es":{"title":"Una Red Diversa de Especialidades M\\u00e9dicas","icon":"fas fa-archive","description":"<p>La red de sucursales hospitalarias de ADoctor abarca varias especialidades m\\u00e9dicas y ofrece a los pacientes una amplia gama de servicios de atenci\\u00f3n m\\u00e9dica. Ya sea que est\\u00e9 buscando chequeos de rutina, atenci\\u00f3n especializada o asesoramiento de expertos, ADoctor lo conecta con una amplia gama de profesionales m\\u00e9dicos, todo bajo un mismo techo.<\\/p>","tags":["m\\u00e9dicas"]},"ar":{"title":"\\u0634\\u0628\\u0643\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u062e\\u0635\\u0635\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629","icon":"fas fa-archive","description":"<p>\\u062a\\u0645\\u062a\\u062f \\u0634\\u0628\\u0643\\u0629 \\u0627\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621 \\u0645\\u0646 \\u0641\\u0631\\u0648\\u0639 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0634\\u0641\\u064a\\u0627\\u062a \\u0625\\u0644\\u0649 \\u0645\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u062a\\u062e\\u0635\\u0635\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629\\u060c \\u0648\\u062a\\u0642\\u062f\\u0645 \\u0644\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u062a\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0641\\u062d\\u0648\\u0635\\u0627\\u062a \\u0631\\u0648\\u062a\\u064a\\u0646\\u064a\\u0629\\u060c \\u0623\\u0648 \\u0631\\u0639\\u0627\\u064a\\u0629 \\u0645\\u062a\\u062e\\u0635\\u0635\\u0629\\u060c \\u0623\\u0648 \\u0645\\u0634\\u0648\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621\\u060c \\u0641\\u0625\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u064a\\u0648\\u0635\\u0644\\u0643 \\u0628\\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u062e\\u0635\\u0635\\u064a\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u064a\\u0646\\u060c \\u0643\\u0644 \\u0630\\u0644\\u0643 \\u062a\\u062d\\u062a \\u0633\\u0642\\u0641 \\u0648\\u0627\\u062d\\u062f.<\\/p>","tags":["\\u0637\\u0628\\u064a"]}},"image":"seeder\\/blog4.webp"}','status' => '1','created_at' => '2023-07-27 10:47:22','updated_at' => '2023-09-14 10:49:56'),
            array('slug' => 'secure-and-accessible-medical-records','data' => '{"language":{"en":{"title":"Secure and Accessible Medical Records","icon":"fas fa-stethoscope","description":"<p>With ADoctor, managing medical records has never been easier. Patients can securely access their medical history, test results, and prescriptions through their online accounts. This seamless access to medical records not only facilitates better communication with doctors but also enables patients to take a more active role in their healthcare journey.<\\/p>","tags":["prescription"]},"es":{"title":"Registros m\\u00e9dicos seguros y accesibles","icon":"fas fa-stethoscope","description":"<p>Con ADoctor, la gesti\\u00f3n de registros m\\u00e9dicos nunca ha sido tan f\\u00e1cil. Los pacientes pueden acceder de forma segura a su historial m\\u00e9dico, resultados de pruebas y recetas a trav\\u00e9s de sus cuentas en l\\u00ednea. Este acceso continuo a los registros m\\u00e9dicos no solo facilita una mejor comunicaci\\u00f3n con los m\\u00e9dicos, sino que tambi\\u00e9n permite a los pacientes asumir un papel m\\u00e1s activo en su proceso de atenci\\u00f3n m\\u00e9dica.<\\/p>","tags":["pruebas"]},"ar":{"title":"\\u0633\\u062c\\u0644\\u0627\\u062a \\u0637\\u0628\\u064a\\u0629 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u064a\\u0645\\u0643\\u0646 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u064a\\u0647\\u0627","icon":"fas fa-stethoscope","description":"<p>\\u0645\\u0639 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628\\u060c \\u0623\\u0635\\u0628\\u062d\\u062a \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0623\\u0633\\u0647\\u0644 \\u0645\\u0646 \\u0623\\u064a \\u0648\\u0642\\u062a \\u0645\\u0636\\u0649. \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0625\\u0644\\u0649 \\u062a\\u0627\\u0631\\u064a\\u062e\\u0647\\u0645 \\u0627\\u0644\\u0637\\u0628\\u064a \\u0648\\u0646\\u062a\\u0627\\u0626\\u062c \\u0627\\u0644\\u0627\\u062e\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0648\\u0627\\u0644\\u0648\\u0635\\u0641\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a\\u0647\\u0645 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a. \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0633 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0644\\u0627 \\u064a\\u0633\\u0647\\u0644 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0623\\u0641\\u0636\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0623\\u0637\\u0628\\u0627\\u0621 \\u0641\\u062d\\u0633\\u0628\\u060c \\u0628\\u0644 \\u064a\\u0645\\u0643\\u0651\\u0646 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u062f\\u0648\\u0631 \\u0623\\u0643\\u062b\\u0631 \\u0646\\u0634\\u0627\\u0637\\u064b\\u0627 \\u0641\\u064a \\u0631\\u062d\\u0644\\u0629 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645.<\\/p>","tags":["\\u0631\\u0648\\u0634\\u062a\\u0629"]}},"image":"seeder\\/blog5.webp"}','status' => '1','created_at' => '2023-07-27 10:49:18','updated_at' => '2023-09-14 10:48:33'),
            array('slug' => 'putting-privacy-first','data' => '{"language":{"en":{"title":"Putting Privacy First","icon":"fas fa-syringe","description":"<p>Patient privacy is a paramount concern for ADoctor. The platform is built with robust security measures to protect sensitive personal information and medical data. Patients can trust that their privacy is a top priority throughout their entire experience with ADoctor.<\\/p>","tags":["security"]},"es":{"title":"Poner la privacidad primero","icon":"fas fa-syringe","description":"<p>La privacidad del paciente es una preocupaci\\u00f3n primordial para ADoctor. La plataforma est\\u00e1 construida con s\\u00f3lidas medidas de seguridad para proteger la informaci\\u00f3n personal confidencial y los datos m\\u00e9dicos. Los pacientes pueden confiar en que su privacidad es una prioridad m\\u00e1xima durante toda su experiencia con ADoctor.<\\/p>","tags":["datos"]},"ar":{"title":"\\u0648\\u0636\\u0639 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0623\\u0648\\u0644\\u0627\\u064b","icon":"fas fa-syringe","description":"<p>\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0631\\u064a\\u0636 \\u0647\\u064a \\u0645\\u0635\\u062f\\u0631 \\u0642\\u0644\\u0642 \\u0628\\u0627\\u0644\\u063a \\u0644\\u0644\\u0637\\u0628\\u064a\\u0628. \\u062a\\u0645 \\u062a\\u0635\\u0645\\u064a\\u0645 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0623\\u0645\\u0646\\u064a\\u0629 \\u0642\\u0648\\u064a\\u0629 \\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0633\\u0629 \\u0648\\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0623\\u0646 \\u064a\\u062b\\u0642\\u0648\\u0627 \\u0628\\u0623\\u0646 \\u062e\\u0635\\u0648\\u0635\\u064a\\u062a\\u0647\\u0645 \\u062a\\u0645\\u062b\\u0644 \\u0623\\u0648\\u0644\\u0648\\u064a\\u0629 \\u0642\\u0635\\u0648\\u0649 \\u0637\\u0648\\u0627\\u0644 \\u062a\\u062c\\u0631\\u0628\\u062a\\u0647\\u0645 \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628.<\\/p>","tags":["\\u062d\\u0645\\u0627\\u064a\\u0629"]}},"image":"seeder\\/blog6.webp"}','status' => '1','created_at' => '2023-07-27 10:51:28','updated_at' => '2023-09-14 10:47:20'),
            array('slug' => 'a-personalized-healthcare-journey','data' => '{"language":{"en":{"title":"A Personalized Healthcare Journey","icon":"fas fa-braille","description":"<p>ADoctor understands that every patient is unique. From selecting the right doctor to booking appointments at the preferred branch, the platform tailors the healthcare journey to match individual needs. This personalization fosters a sense of empowerment, encouraging patients to take charge of their health with confidence.<\\/p>","tags":["empowerment"]},"es":{"title":"Un viaje de atenci\\u00f3n m\\u00e9dica personalizado","icon":"fas fa-braille","description":"<p>ADoctor entiende que cada paciente es \\u00fanico. Desde la selecci\\u00f3n del m\\u00e9dico adecuado hasta la reserva de citas en la sucursal preferida, la plataforma adapta el viaje de atenci\\u00f3n m\\u00e9dica para satisfacer las necesidades individuales. Esta personalizaci\\u00f3n fomenta una sensaci\\u00f3n de empoderamiento, alentando a los pacientes a hacerse cargo de su salud con confianza.<\\/p>","tags":["empoderamiento"]},"ar":{"title":"\\u0631\\u062d\\u0644\\u0629 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629","icon":"fas fa-braille","description":"<p>\\u064a\\u0641\\u0647\\u0645 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0623\\u0646 \\u0643\\u0644 \\u0645\\u0631\\u064a\\u0636 \\u0641\\u0631\\u064a\\u062f \\u0645\\u0646 \\u0646\\u0648\\u0639\\u0647. \\u0628\\u062f\\u0621\\u064b\\u0627 \\u0645\\u0646 \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0633\\u0628 \\u0648\\u062d\\u062a\\u0649 \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0641\\u0631\\u0639 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u060c \\u062a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0628\\u062a\\u0635\\u0645\\u064a\\u0645 \\u0631\\u062d\\u0644\\u0629 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0644\\u062a\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0645\\u0639 \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u0641\\u0631\\u062f\\u064a\\u0629. \\u064a\\u0639\\u0632\\u0632 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062a\\u062e\\u0635\\u064a\\u0635 \\u0627\\u0644\\u0634\\u0639\\u0648\\u0631 \\u0628\\u0627\\u0644\\u062a\\u0645\\u0643\\u064a\\u0646\\u060c \\u0648\\u064a\\u0634\\u062c\\u0639 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0639\\u0644\\u0649 \\u062a\\u0648\\u0644\\u064a \\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629 \\u0635\\u062d\\u062a\\u0647\\u0645 \\u0628\\u062b\\u0642\\u0629.<\\/p>","tags":["\\u0627\\u0644\\u062a\\u0645\\u0643\\u064a\\u0646"]}},"image":"seeder\\/blog7.webp"}','status' => '1','created_at' => '2023-07-27 10:53:24','updated_at' => '2023-09-14 10:46:07'),
            array('slug' => 'innovating-the-future-of-healthcare','data' => '{"language":{"en":{"title":"Innovating the Future of Healthcare","icon":"fas fa-newspaper","description":"<p>As the healthcare landscape continues to evolve, ADoctor remains at the forefront of innovation. The platform continuously seeks feedback from users, medical professionals, and industry experts to enhance its services. By leveraging technology and embracing patient-centric care, ADoctor is setting new standards for the future of healthcare.<\\/p><p>In conclusion, ADoctor\'s vision is to make healthcare accessible, transparent, and patient-driven. By embracing technology, fostering transparency, and putting patients in control of their healthcare decisions, ADoctor is revolutionizing the way we experience medical care. With a commitment to excellence and an unwavering dedication to patient well-being, ADoctor is paving the way for a healthier and more connected future.<\\/p>","tags":["healthier"]},"es":{"title":"Innovando el futuro de la atenci\\u00f3n m\\u00e9dica","icon":"fas fa-newspaper","description":"<p>A medida que el panorama de la atenci\\u00f3n m\\u00e9dica contin\\u00faa evolucionando, ADoctor se mantiene a la vanguardia de la innovaci\\u00f3n. La plataforma busca continuamente comentarios de usuarios, profesionales m\\u00e9dicos y expertos de la industria para mejorar sus servicios. Al aprovechar la tecnolog\\u00eda y adoptar la atenci\\u00f3n centrada en el paciente, ADoctor est\\u00e1 estableciendo nuevos est\\u00e1ndares para el futuro de la atenci\\u00f3n m\\u00e9dica.<\\/p><p>En conclusi\\u00f3n, la visi\\u00f3n de ADoctor es hacer que la atenci\\u00f3n m\\u00e9dica sea accesible, transparente y orientada al paciente. Al adoptar la tecnolog\\u00eda, fomentar la transparencia y dar a los pacientes el control de sus decisiones de atenci\\u00f3n m\\u00e9dica, ADoctor est\\u00e1 revolucionando la forma en que experimentamos la atenci\\u00f3n m\\u00e9dica. Con un compromiso con la excelencia y una dedicaci\\u00f3n inquebrantable al bienestar del paciente, ADoctor est\\u00e1 allanando el camino para un futuro m\\u00e1s saludable y conectado.<\\/p>","tags":["decisiones"]},"ar":{"title":"\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631 \\u0645\\u0633\\u062a\\u0642\\u0628\\u0644 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629","icon":"fas fa-newspaper","description":"<p>\\u0645\\u0639 \\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u062a\\u0637\\u0648\\u0631 \\u0645\\u0634\\u0647\\u062f \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629\\u060c \\u064a\\u0638\\u0644 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0641\\u064a \\u0637\\u0644\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631. \\u062a\\u0633\\u0639\\u0649 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u0639\\u0644\\u064a\\u0642\\u0627\\u062a \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0647\\u0646\\u064a\\u064a\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u064a\\u0646 \\u0648\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u0629 \\u0644\\u062a\\u0639\\u0632\\u064a\\u0632 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0647\\u0627. \\u0648\\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627 \\u0648\\u062a\\u0628\\u0646\\u064a \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0631\\u0643\\u0632 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0631\\u064a\\u0636\\u060c \\u064a\\u0636\\u0639 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0645\\u0633\\u062a\\u0642\\u0628\\u0644 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629.<\\/p><p>\\u0641\\u064a \\u0627\\u0644\\u062e\\u062a\\u0627\\u0645\\u060c \\u062a\\u062a\\u0645\\u062b\\u0644 \\u0631\\u0624\\u064a\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0641\\u064a \\u062c\\u0639\\u0644 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0645\\u062a\\u0627\\u062d\\u0629 \\u0648\\u0634\\u0641\\u0627\\u0641\\u0629 \\u0648\\u0645\\u0648\\u062c\\u0647\\u0629 \\u0646\\u062d\\u0648 \\u0627\\u0644\\u0645\\u0631\\u064a\\u0636. \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062a\\u0628\\u0646\\u064a \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629\\u060c \\u0648\\u0648\\u0636\\u0639 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u0637\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645\\u060c \\u064a\\u064f\\u062d\\u062f\\u062b ADoctor \\u062b\\u0648\\u0631\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0646\\u062e\\u062a\\u0628\\u0631 \\u0628\\u0647\\u0627 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629. \\u0645\\u0639 \\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645 \\u0628\\u0627\\u0644\\u062a\\u0645\\u064a\\u0632 \\u0648\\u0627\\u0644\\u062a\\u0641\\u0627\\u0646\\u064a \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u062a\\u0632\\u0639\\u0632\\u0639 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0631\\u0641\\u0627\\u0647\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0631\\u064a\\u0636\\u060c \\u064a\\u0645\\u0647\\u062f \\u0627\\u0644\\u0637\\u0628\\u064a\\u0628 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642 \\u0644\\u0645\\u0633\\u062a\\u0642\\u0628\\u0644 \\u0623\\u0643\\u062b\\u0631 \\u0635\\u062d\\u0629 \\u0648\\u0623\\u0643\\u062b\\u0631 \\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u064b.<\\/p>","tags":["\\u0623\\u0643\\u062b\\u0631 \\u0635\\u062d\\u0629"]}},"image":"seeder\\/blog8.webp"}','status' => '1','created_at' => '2023-07-27 10:55:08','updated_at' => '2023-09-14 10:44:32')
        );
        Journal::upsert($journals,['slug'],[]);
    }
}
