

<?php $__env->startSection('content'); ?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Booking section  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<div class="body-wrapper">
    <div class="row mb-30-none justify-content-center">
        <div class="col-lg-6 col-md-6 col-sm-12 mb-30">
            <div class="booking-area">
                <h4 class="title"><i class="fas fa-user text--base me-2"></i><?php echo e(__("Doctor Information")); ?></h4>
                <div class="thumb">
                    <img src="<?php echo e(get_image($booking->doctors->image ?? '' , 'site-section') ?? ''); ?>" alt="profile">
                </div>
                <div class="content">
                    <div class="list-wrapper">
                        <ul class="list">
                            <li><?php echo e(__("Name")); ?><span><?php echo e($booking->doctors->name ?? ""); ?></span></li>
                            <li><?php echo e(__("Qualifications")); ?><span><?php echo e($booking->doctors->qualification ?? ""); ?></span></li>
                            <li><?php echo e(__("Speciality")); ?><span><?php echo e($booking->doctors->speciality ?? ""); ?></span></li>
                            <li><?php echo e(__("Contact")); ?><span><?php echo e($booking->doctors->contact ?? ""); ?></span></li>
                            <li><?php echo e(__("Floor Number")); ?><span><?php echo e($booking->doctors->floor_number ?? ""); ?></span></li>
                            <li><?php echo e(__("Room Number")); ?><span><?php echo e($booking->doctors->room_number ?? ""); ?></span></li>
                            <li><?php echo e(__("Fees")); ?><span><?php echo e(get_amount($booking->doctors->fees ?? "")); ?></span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-12 mb-30">
            <div class="booking-area">
                <h4 class="title"><i class="fas fa-calendar-check text--base me-2"></i><?php echo e(__("Schedule Information")); ?></h4>
                <div class="content pt-0">
                    <div class="list-wrapper">
                        <ul class="list">
                            <?php
                            
                                $from_time        = $booking->schedules->from_time ?? '';
                                $parsed_from_time = \Carbon\Carbon::createFromFormat('H:i', $from_time)->format('h A');

                                $to_time          = $booking->schedules->to_time ?? '';
                                $parsed_to_time   = \Carbon\Carbon::createFromFormat('H:i', $to_time)->format('h A');

                            ?>
                            <li><?php echo e(__("Day")); ?><span><?php echo e($booking->schedules->week->day ?? ""); ?></span></li>
                            <li><?php echo e(__("From Time")); ?><span><?php echo e($parsed_from_time ?? ''); ?></span></li>
                            <li><?php echo e(__("To Time")); ?><span><?php echo e($parsed_to_time ?? ''); ?></span></li>
                            <?php if(isset($booking->prescription)): ?>
                                <li><?php echo e(__("Prescription")); ?><span><a class="btn btn--base" href="<?php echo e(setRoute('user.history.prescription.download',$booking->slug)); ?>"><?php echo e(__("Download")); ?></a></span></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="list-wrapper pt-20">
                        <h4 class="title text--base"><i class="fas fa-clipboard-list text--base me-2"></i><?php echo e(__("Serial")); ?></h4>
                        <ul class="list">
                            <li><?php echo e(__("Serial Number")); ?><span><?php echo e($booking->patient_number ?? ""); ?></span></li>
                            
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Booking section  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/user/sections/history/details.blade.php ENDPATH**/ ?>