<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Faq
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<?php
    $app_local  = get_default_language_code();
?>



<section class="faq-section pb-120 <?php echo e($class ?? ""); ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-6">
                <div class="section-header">
                    <span class="section-sub-titel"><i class="fas fa-briefcase-medical"></i> <?php echo e($faq->value->language->$app_local->title ?? ""); ?> </span>
                    <h2 class="section-title"> <?php echo e($faq->value->language->$app_local->heading ?? ""); ?></h2>
                    <p><?php echo e($faq->value->language->$app_local->sub_heading ?? ""); ?></p>
                </div>
            </div>
        </div>
        <?php
            $items    = $faq->value->items;
            $itemsData = (array) $items;

            $data = array_chunk($itemsData, ceil(count($itemsData) / 2));

            $part1 = $data[0];
            $part2 = $data[1];
        ?>
        <div class="row justify-content-center mb-30-none">
            <div class="col-xl-6 col-lg-6 mb-30">
                <div class="faq-wrapper">
                    <?php $__currentLoopData = $part1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->status == 1): ?>
                            <div class="faq-item">
                                <h3 class="faq-title"><span class="title"><?php echo e($item->language->$app_local->question ?? ""); ?></span><span class="right-icon"></span></h3>
                                <div class="faq-content">
                                    <p><?php echo e($item->language->$app_local->answer ?? ""); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                </div>
            </div>
            <div class="col-xl-6 col-lg-6 mb-30">
                <div class="faq-wrapper">
                    <?php $__currentLoopData = $part2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->status == 1): ?>
                            <div class="faq-item">
                                <h3 class="faq-title"><span class="title"><?php echo e($item->language->$app_local->question ?? ""); ?></span><span class="right-icon"></span></h3>
                                <div class="faq-content">
                                    <p><?php echo e($item->language->$app_local->answer ?? ""); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        
    </div>
</section>

<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Faq
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php /**PATH /home/penastud/public_html/doctor/resources/views/frontend/section/faq.blade.php ENDPATH**/ ?>