

<?php $__env->startPush('css'); ?>

    <style>
        .fileholder {
            min-height: 374px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,.fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view{
            height: 330px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ],
        [
            'name'  => __("Appointments"),
            'url'   => setRoute("admin.booking.index"),
        ]
    ], 'active' => __("Booking Details")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row mb-30-none">
    <div class="col-lg-4 mb-30">
        <div class="booking-area">
            <h4 class="title"><i class="fas fa-user text--base me-2"></i><?php echo e(__("Doctor Information")); ?></h4>
            <div class="thumb">
                <img src="<?php echo e(get_image($appointment->doctors->image ?? '','site-section') ?? ''); ?>" alt="profile">
            </div>
            <div class="content">
                <div class="list-wrapper">
                    <ul class="list">
                        <li><?php echo e(__("Name")); ?>:<span><?php echo e($appointment->doctors->name ?? ""); ?></span></li>
                        <li><?php echo e(__("Qualifications")); ?>:<span><?php echo e($appointment->doctors->qualification ?? ""); ?></span></li>
                        <li><?php echo e(__("Speciality")); ?>:<span><?php echo e($appointment->doctors->speciality ?? ""); ?></span></li>
                        <li><?php echo e(__("Contact")); ?>:<span><?php echo e($appointment->doctors->contact ?? ""); ?></span></li>
                        <li><?php echo e(__("Floor Number")); ?>:<span><?php echo e($appointment->doctors->floor_number ?? ""); ?></span></li>
                        <li><?php echo e(__("Room Number")); ?>:<span><?php echo e($appointment->doctors->room_number ?? ""); ?></span></li>
                        <li><?php echo e(__("Max")); ?> <?php echo e(__("Patient")); ?>:<span><?php echo e($appointment->schedules->max_patient ?? ""); ?></span></li>
                        <li><?php echo e(__("Fees")); ?>:<span><?php echo e(get_amount($appointment->doctors->fees ?? "")); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4 mb-30">
        <div class="booking-area">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="title mb-0"><i class="fas fa-user text--base me-2"></i><?php echo e(__("Patient Information")); ?></h4>
                <div>
                    <?php echo $__env->make('admin.components.link.custom',[
                        'href'          => "#send-reply",
                        'class'         => "btn btn--base reply-button modal-btn",
                        'icon'          => "las la-reply-all",
                        'permission'    => "admin.booking.messages.reply",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
           
            <div class="content pt-0">
                <div class="list-wrapper">
                    <ul class="list">
                        <li><?php echo e(__("Name")); ?>:<span><?php echo e($appointment->name ?? ""); ?></span></li>
                        <li><?php echo e(__("Email")); ?>:<span><?php echo e($appointment->email ?? ""); ?></span></li>
                        <li><?php echo e(__("Phone")); ?>:<span><?php echo e($appointment->phone ?? ""); ?></span></li>
                        <li><?php echo e(__("Gender")); ?>:<span><?php echo e($appointment->gender ?? ""); ?></span></li>
                        <li><?php echo e(__("Type")); ?>:<span><?php echo e($appointment->type?? ""); ?></span></li>
                        <li><?php echo e(__("Message")); ?>:<span><?php echo e($appointment->message ?? ""); ?></span></li>
                        <li><?php echo e(__("Patient Number")); ?>:<span><?php echo e($appointment->patient_number ?? ""); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4 mb-30">
        <div class="booking-area">
            <h4 class="title"><i class="fas fa-user text--base me-2"></i><?php echo e(__("Schedule Information")); ?></h4>
            <div class="content pt-0">
                <div class="list-wrapper">
                    <ul class="list">
                        <?php
                            $from_time = $appointment->schedules->from_time ?? '';
                            $parsed_from_time = \Carbon\Carbon::createFromFormat('H:i', $from_time)->format('h A');

                            $to_time   = $appointment->schedules->to_time ?? '';
                            $parsed_to_time = \Carbon\Carbon::createFromFormat('H:i', $to_time)->format('h A');
                        ?>
                        <li><?php echo e(__("Day")); ?>:<span><?php echo e($appointment->schedules->week->day ?? ""); ?></span></li>
                        <li><?php echo e(__("From Time")); ?>:<span><?php echo e($parsed_from_time ?? ""); ?></span></li>
                        <li><?php echo e(__("To Time")); ?>:<span><?php echo e($parsed_to_time ?? ""); ?></span></li>
                        <?php if(isset($appointment->prescription)): ?>
                            <li><?php echo e(__("Prescription")); ?>:<span><a class="btn btn--base" href="<?php echo e(setRoute('booking.download.prescription',['slug' => $appointment->slug])); ?>"><?php echo e(__("Download")); ?></a></span></li>
                        <?php endif; ?>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-12 col-lg-12 form-group">
        <div class="booking-area mb-5">
            <form action="<?php echo e(setRoute('admin.booking.prescription.upload',$appointment->slug)); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="col-xl-12 col-lg-12 form-group">
                    <h4 class="title"><?php echo e(__("Prescription")); ?></h4>
                    <div class="input">
                        <input type="file" name="prescription">
                    </div>
                </div>
                <div class="col-xl-12 col-lg-12 form-group">
                    <?php echo $__env->make('admin.components.button.form-btn',[
                        'class'         => "w-100 btn-loading",
                        'text'          => __("Send Prescription"),
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </form>
        </div>
    </div>
</div>
<?php if(admin_permission_by_name("admin.booking.messages.reply")): ?>
        <div id="send-reply" class="mfp-hide large">
            <div class="modal-data">
                <div class="modal-header px-0">
                    <h5 class="modal-title"><?php echo e(__("Send Reply")); ?></h5>
                </div>
                <div class="modal-form-data">
                    <form class="card-form" action="<?php echo e(setRoute('admin.booking.messages.reply')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="target" value="<?php echo e(old('target')); ?>">
                        <div class="row mb-10-none">
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                    'label'         => __("Subject")."*",
                                    'name'          => "subject",
                                    'data_limit'    => 150,
                                    'placeholder'   => __("Write Subject")."...",
                                    'value'         => old('subject'),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input-text-rich',[
                                    'label'         => __("Details")."*",
                                    'name'          => "message",
                                    'value'         => old('message'),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.button.form-btn',[
                                    'class'         => "w-100 btn-loading",
                                    'permission'    => "admin.subscriber.send.mail",
                                    'text'          => __("Send Email"),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>


<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        openModalWhenError("send-reply","#send-reply");
        $(".reply-button").click(function(){
            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            $("#send-reply").find("input[name=target]").val(oldData.id);
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/admin/sections/booking-appointment/view.blade.php ENDPATH**/ ?>