<?php
    $menues = DB::table('setup_pages')->where('status', 1)->get();
?>

<header class="header-section <?php echo e($class ?? ""); ?>">
    <div class="header">
        <div class="header-middle-area">
            <div class="container">
                <div class="header-middle-wrapper">
                    <a class="site-logo site-title" href="<?php echo e(setRoute('index')); ?>"><img src="<?php echo e(get_logo($basic_settings)); ?> " alt="site-logo"></a>
                    <div class="header-middle-content">
                        <div class="header-address-area">
                            <div class="header-address-item">
                                <a href="mailto:<?php echo e($contact->value->email); ?>" class="thumb">
                                    <img src="<?php echo e(asset('public/frontend/images/icon/support.gif')); ?> " alt="l">
                                </a>
                                <div class="content">
                                    <?php
                                        use Illuminate\Mail\Markdown;
                                    ?>
                                    <span><?php echo e($contact->value->address ?? ""); ?></span>
                                    <a href="mailto:<?php echo e($contact->value->email); ?>" class="title"><?php echo e($contact->value->email ?? ""); ?></a>
                                </div>
                            </div>
                            <div class="header-address-item">
                                <a href="tel:<?php echo e($contact->value->phone); ?>" class="thumb">
                                    <img src="<?php echo e(asset('public/frontend/images/icon/phone.gif')); ?> " alt="l">
                                </a>
                                <div class="content">
                                    <span><?php echo e(__("Contact Us")); ?></span>
                                    <a href="tel:<?php echo e($contact->value->phone); ?>" class="title"><?php echo e($contact->value->phone ?? ""); ?></a>
                                </div>
                            </div>
                        </div>
                        <ul class="header-social-list">
                            <?php
                                $items      = $footer->value->social_links ?? [];
                            ?>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e($item->link); ?>" target="_blank"><i class="<?php echo e($item->icon); ?>"></i></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                            
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-bottom-area">
            <div class="container">
                <div class="header-menu-content">
                    <nav class="navbar navbar-expand-lg p-0">
                        <a class="site-logo site-title" href="<?php echo e(setRoute('index')); ?>"><img src="<?php echo e(get_logo($basic_settings)); ?>" alt="site-logo"></a>
                        <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
                            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="fas fa-bars"></span>
                        </button>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <?php
                                $current_url = URL::current();
                            ?>
                            <ul class="navbar-nav main-menu me-auto">

                                <?php $__currentLoopData = $menues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $title = $item->title ?? "";
                                    ?>
                                    <li><a href="<?php echo e(url($item->url)); ?>" class=" <?php if($current_url == url($item->url)): ?> active <?php endif; ?> "><?php echo e(__($title)); ?> <i class="fas fa-caret-right"></i></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if(auth()->guard()->check()): ?>
                                <li><a href="<?php echo e(setRoute('user.profile.index')); ?>" ><?php echo e(__("Dashboard")); ?> <i class="fas fa-caret-right"></i></a></li>
                                <?php else: ?>
                                <li><a href="javascript:void(0)" class="account-area-btn"><?php echo e(__("Login")); ?> <i class="fas fa-caret-right"></i></a></li>
                                <?php endif; ?>
                                
                            </ul>
                            <div class="header-action">
                                <div class="language-select">
                                    <?php
                                        $__current_local = session("local") ?? get_default_language_code();
                                    ?>
                                    <select class="form--control nice-select" name="lang_switcher" id="">
                                        <?php $__currentLoopData = $__languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $__item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($__item->code); ?>" <?php if($__current_local == $__item->code): ?>
                                                <?php if(true): echo 'selected'; endif; ?>
                                            <?php endif; ?>><?php echo e($__item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                
                                </div>
                                <a href="javascript:void(0)" class="btn--base" data-bs-toggle="modal" data-bs-target=".bd-example-modal-app"><i class="lab la-google-play me-2"></i><?php echo e(__("Download App")); ?></a>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>


<?php $__env->startPush('script'); ?>
<script>
    $("select[name=lang_switcher]").change(function(){
        var selected_value = $(this).val();
        var submitForm = `<form action="<?php echo e(setRoute('languages.switch')); ?>" id="local_submit" method="POST"> <?php echo csrf_field(); ?> <input type="hidden" name="target" value="${$(this).val()}" ></form>`;
        $("body").append(submitForm);
        $("#local_submit").submit();
    });
</script>
<?php $__env->stopPush(); ?>

<?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/partials/header.blade.php ENDPATH**/ ?>