<?php
    $app_local     = get_default_language_code();
?>


<footer class="footer-section pt-40 pb-20 bg_img" data-background="<?php echo e(asset('public/frontend/images/element/footer-element.jpg')); ?> ">
    <div class="container">
        <div class="footer-wrapper">
            <div class="row mb-30-none">
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-30">
                    
                    <div class="footer-widget">
                        <div class="footer-logo">
                            <a class="site-logo site-title" href="<?php echo e(setRoute('index')); ?>"><img src=" <?php echo e(@$footer->value->footer->image ? get_image($footer->value->footer->image,'site-section') : get_logo($basic_settings)); ?> " alt="site-logo"></a>
                        </div>
                        <div class="footer-content">
                            <p><?php echo e($footer->value->footer->language->$app_local->description ?? ''); ?></p>
                        </div>
                        <div class="footer-content-bottom">
                            <ul class="footer-list logo">
                                <?php
                                    $items = $footer->value->communication_links?? [];
                                ?>                                
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $phone_number  = remove_special_char($item->communication_link);
                                    ?>
                                    <?php if(is_numeric($phone_number)): ?>
                                    <li><a href="tel:<?php echo e($item->communication_link); ?>" style="text-transform: lowercase;"><i class="<?php echo e($item->communication_icon ?? ''); ?> "></i> <?php echo e($item->communication_link ?? ''); ?></a></li>
                                    <?php else: ?>
                                        <li><a href="mailto:<?php echo e($item->communication_link); ?>" style="text-transform: lowercase;"><i class="<?php echo e($item->communication_icon ?? ''); ?> "></i> <?php echo e($item->communication_link ?? ''); ?></a></li>  
                                    <?php endif; ?>    
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <h4 class="widget-title"><?php echo e(__("Usefull Links")); ?></h4>
                        <ul class="footer-list">
                            <?php if($useful_links): ?>
                                <?php $__currentLoopData = $useful_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(setRoute('link',$item->slug)); ?>"><?php echo e($item->title->language?->$app_local?->title ?? ""); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <h4 class="widget-title"><?php echo e(__($app_settings->url_title) ?? ''); ?></h4>
                        <ul class="footer-list two">
                            <li><a href="<?php echo e($app_settings->android_url ?? ''); ?>" class="app-img" target="_blank"><img src="<?php echo e(asset('public/frontend/images/app/play_store.png')); ?> " alt="app"></a></li>
                            <li><a href="<?php echo e($app_settings->iso_url ?? ''); ?>" class="app-img" target="_blank"><img src="<?php echo e(asset('public/frontend/images/app/app_store.png')); ?> " alt="app"></a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <h4 class="widget-title"><?php echo e($news_letter->value->language->$app_local->title ?? ''); ?></h4>
                        <p><?php echo e($news_letter->value->language->$app_local->description ?? ''); ?></p>
                        <form id="subscribe-form" class="footer-list two" action="<?php echo e(setRoute('subscribe')); ?> " method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <input type="text" placeholder="<?php echo e(__("Name")); ?>" name="name" class="form--control">
                                <span class="input-icon"><i class="las la-user"></i></span>
                            </div>
                            <div class="form-group">
                                <input type="email" placeholder="<?php echo e(__("Email")); ?>" name="email" class="form--control" required>
                                <span class="input-icon"><i class="las la-envelope"></i></span>
                            </div>
                            <div class="footer-btn-area">
                                <button type="submit" class="btn--base sub-btn"><?php echo e(__("Subscribe")); ?> <i class="las la-arrow-right ms-1"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="copyright-area">
                <div class="copyright-wrapper">
                    <p>© <?php echo e(__("Created by")); ?> <span class="text--base"><?php echo e($basic_settings->site_name); ?></span> 2024.</p>
                    <ul class="footer-social-list">
                        <?php
                            $items = $footer->value->social_links ?? [];
                        ?>
                        
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e($item->link); ?>" target="_blank"><i class="<?php echo e($item->icon); ?>"></i></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH /home/penastud/public_html/doctor/resources/views/frontend/partials/footer.blade.php ENDPATH**/ ?>