



<?php $__env->startSection('content'); ?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Booking section  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="booking-section ptb-120">
    <div class="container">
        <form class="booking-form" action="<?php echo e(setRoute('frontend.appointment.booking.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="doctor" value="<?php echo e($doctor->slug); ?>">
            <div class="row justify-content-center mb-30-none">
                <div class="col-xl-5 col-lg-6 col-md-12 mb-30">
                    <div class="booking-area">
                        <div class="thumb">
                            <img src="<?php echo e(get_image($doctor->image ?? '' , 'site-section') ?? ''); ?>" alt="profile">
                        </div>
                        <div class="content">
                            <h4 class="title"><i class="fas fa-user text--base me-2"></i><?php echo e($doctor->name ?? ""); ?></h4>
                            <div class="list-wrapper">
                                <ul class="list">
                                    <li><?php echo e(__("Qualifications")); ?>:<span><?php echo e($doctor->qualification ?? ""); ?></span></li>
                                    <li><?php echo e(__("Speciality")); ?>:<span><?php echo e($doctor->speciality ?? ""); ?></span></li>
                                    <li><?php echo e(__("Language Spoken")); ?>:<span><?php echo e($doctor->language?? ""); ?></span></li>
                                    <li><?php echo e(__("Designation")); ?>:<span><?php echo e($doctor->designation ?? ""); ?></span></li>
                                    <li><?php echo e(__("Department Name")); ?>:<span><?php echo e($doctor['department']['name'] ?? ""); ?></span></li>
                                </ul>
                            </div>
                            <div class="list-wrapper pt-20">
                                <h4 class="title text--base"><i class="fas fa-info-circle"></i> <?php echo e(__("Chamber")); ?></h4>
                                <ul class="list">
                                    <li><?php echo e(__("Contact")); ?>:<span><?php echo e($doctor->contact ?? ""); ?></span></li>
                                    <li><?php echo e(__("Off Day")); ?>:<span><?php echo e($doctor->off_days ?? ""); ?></span></li>
                                    <li><?php echo e(__("Floor Number")); ?>:<span><?php echo e($doctor->floor_number ?? ""); ?></span></li>
                                    <li><?php echo e(__("Room Number")); ?>:<span><?php echo e($doctor->room_number ?? ""); ?></span></li>
                                    <li><?php echo e(__("Branch Name")); ?>:<span><?php echo e($doctor['branch']['name'] ?? ""); ?></span></li>
                                    <li><?php echo e(__("Address")); ?>:<span><?php echo e($doctor->address ?? ""); ?></span></li>
                                    <li><?php echo e(__("Fees")); ?>:<span><?php echo e(get_amount($doctor->fees) ?? ""); ?> <?php echo e(App\Providers\Admin\CurrencyProvider::default()->code); ?></span></li>
                                </ul>
                            </div>
                            <div class="list-wrapper pt-20">
                                <h4 class="title text--base"><i class="fas fa-history"></i> <?php echo e(__("Schedule")); ?></h4>
                                <div class="shedule-option pt-10">
                                    <?php $__currentLoopData = $doctor->schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="shedule-item">
                                            <?php
                                                $from_time = $day->from_time ?? '';
                                                $parsed_from_time = \Carbon\Carbon::createFromFormat('H:i', $from_time)->format('h A');

                                                $to_time   = $day->to_time ?? '';
                                                $parsed_to_time = \Carbon\Carbon::createFromFormat('H:i', $to_time)->format('h A');
                                            ?>
                                            <div class="shedule-inner">
                                                <input type="radio" name="schedule" value="<?php echo e($day->id); ?>" class="hide-input" id="shedule_<?php echo e($day->id); ?>">
                                                <label for="shedule_<?php echo e($day->id); ?>" class="package--amount">
                                                    <strong><?php echo e($day->week->day); ?></strong>
                                                    <sup>
                                                        <?php echo e($parsed_from_time); ?> -
                                                    </sup>
                                                    <sup>
                                                        <?php echo e($parsed_to_time); ?>

                                                    </sup>
                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($validated_user): ?>
                    <div class="col-xl-7 col-lg-6 col-md-12 mb-30">
                        <div class="booking-area fixed">
                            <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i> <?php echo e(__("Appointment Form")); ?></h3>
                            <div class="row justify-content-center mb-20-none">
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Patient Name").'<span class="text--base">*</span>',
                                        'name'         => 'name',
                                        'value'        => $validated_user->fullName,
                                        'attribute'    => "readonly",
                                        'placeholder'  => __("Enter Name").'...',
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <?php if($validated_user->full_mobile): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                        <?php echo $__env->make('admin.components.form.input',[
                                            'label'        => __("Mobile").'<span class="text--warning">'.'('.__("Optional").')'.'</span>',
                                            'name'         => 'phone',
                                            'value'        => $validated_user->full_mobile,
                                            'attribute'    => "readonly",
                                            'placeholder'  => __("Mobile").'...',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div> 
                                <?php else: ?>
                                    <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                        <?php echo $__env->make('admin.components.form.input',[
                                            'label'        => __("Mobile").'<span class="text--warning">'.'('.__("Optional").')'.'</span>',
                                            'name'         => 'phone',
                                            'value'        => old('phone'),
                                            'placeholder'  => __("Mobile").'...',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                <?php endif; ?>
                                <div class="col-xl-12 col-lg-12 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Email").'<span class="text--base">*</span>',
                                        'name'         => 'email',
                                        'value'        => $validated_user->email,
                                        'attribute'    => 'readonly',
                                        'placeholder'  => __("Email").'...'
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12 form-group">
                                    <label><?php echo e(__("Age")); ?> <span class="text--base">*</span></label>
                                    <div class="input-group">
                                        <input type="number" name="age" min="1" class="form--control" placeholder="<?php echo e(__("Enter your age")); ?>">
                                        <select name="age_type" class="form--control">
                                            <option  selected value="Years"><?php echo e(__("Years")); ?></option>
                                            <option value="Months"><?php echo e(__("Months")); ?></option>
                                            <option value="Days"><?php echo e(__("Days")); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <label><?php echo e(__("Type")); ?><span class="text--base">*</span></label>
                                        <select class="form--control" name="type">
                                            <option selected disabled><?php echo e(__("Select Type")); ?></option>
                                            <option value="<?php echo e(global_const()::APPOINTMENT_TYPE_NEW); ?>"><?php echo e(global_const()::APPOINTMENT_TYPE_NEW); ?></option>
                                            <option value="<?php echo e(global_const()::APPOINTMENT_TYPE_REPORT); ?>"><?php echo e(global_const()::APPOINTMENT_TYPE_REPORT); ?></option>
                                            <option value="<?php echo e(global_const()::APPOINTMENT_TYPE_FOLLOWUP); ?>"><?php echo e(global_const()::APPOINTMENT_TYPE_FOLLOWUP); ?></option>
                                        </select>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <label><?php echo e(__("Gender")); ?><span class="text--base">*</span></label>
                                        <select class="form--control" name="gender">
                                            <option selected disabled><?php echo e(__("Select Gender")); ?></option>
                                            <option value="<?php echo e(global_const()::GENDER_MALE); ?>"><?php echo e(global_const()::GENDER_MALE); ?></option>
                                            <option value="<?php echo e(global_const()::GENDER_FEMALE); ?>"><?php echo e(global_const()::GENDER_FEMALE); ?></option>
                                            <option value="<?php echo e(global_const()::GENDER_OTHER); ?>"><?php echo e(global_const()::GENDER_OTHER); ?></option>
                                        </select>
                                </div>
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <?php echo $__env->make('admin.components.form.textarea',[
                                        'label'         => __("Message").'<span class="text--warning">'.'('.__("Optional").')'.'</span>',
                                        'name'          => 'message',
                                        'placeholder'   => __("Write Here")."...",
                                        'value'         => old("message")
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    
                                </div>
                                <div class="col-lg-12 form-group">
                                    <button type="submit" class="btn--base small w-100"><?php echo e(__("Proceed")); ?> <i class="fas fa-chevron-circle-right ms-1"></i></button>
                                </div>
                            </div>
                        </div>
                    </div> 
                <?php else: ?>
                    <div class="col-xl-7 col-lg-6 col-md-12 mb-30">
                        <div class="booking-area fixed">
                            <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i><?php echo e(__("Appointment Form")); ?></h3>
                            <div class="row justify-content-center mb-20-none">
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Patient Name").'<span class="text--base">*</span>',
                                        'name'         => 'name',
                                        'value'        => old('name'),
                                        'placeholder'  => __("Enter Name").'...',
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Mobile").'<span class="text--warning">'.'('.__("Optional").')'.'</span>',
                                        'name'         => 'phone',
                                        'value'        => old('phone'),
                                        'placeholder'  => __("Mobile").'...',
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'        => __("Email").'<span class="text--base">*</span>',
                                        'name'         => 'email',
                                        'value'        => old('email'),
                                        'placeholder'  => __("Email").'...'
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12 form-group">
                                    <label><?php echo e(__("Age")); ?> <span class="text--base">*</span></label>
                                    <?php
                                        $age_type   = old("age_type");  
                                    ?>
                                    <div class="input-group">
                                        <input type="number" name="age" value="<?php echo e(old("age")); ?>" min="1" class="form--control" placeholder="<?php echo e(__("Enter your age")); ?>">
                                        <select name="age_type" class="form--control">
                                            <option  selected value="Years" <?php if($age_type == "Years"): ?> selected <?php endif; ?>><?php echo e(__("Years")); ?></option>
                                            <option value="Months" <?php if($age_type == "Months"): ?> selected <?php endif; ?>><?php echo e(__("Months")); ?></option>
                                            <option value="Days" <?php if($age_type == "Days"): ?> selected <?php endif; ?>><?php echo e(__("Days")); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <label><?php echo e(__("Type")); ?> <span class="text--base">*</span></label>
                                        <?php
                                            $type = old("type");
                                        ?>
                                        <select class="form--control" name="type">
                                            <option selected disabled><?php echo e(__("Select Type")); ?></option>
                                            <option value="<?php echo e(global_const()::APPOINTMENT_TYPE_NEW); ?>"  <?php if($type == global_const()::APPOINTMENT_TYPE_NEW ): ?> selected <?php endif; ?>><?php echo e(global_const()::APPOINTMENT_TYPE_NEW); ?></option>

                                            <option value="<?php echo e(global_const()::APPOINTMENT_TYPE_REPORT); ?>"  <?php if($type == global_const()::APPOINTMENT_TYPE_REPORT ): ?> selected <?php endif; ?>><?php echo e(global_const()::APPOINTMENT_TYPE_REPORT); ?></option>

                                            <option value="<?php echo e(global_const()::APPOINTMENT_TYPE_FOLLOWUP); ?>" <?php if($type == global_const()::APPOINTMENT_TYPE_FOLLOWUP ): ?> selected <?php endif; ?>><?php echo e(global_const()::APPOINTMENT_TYPE_FOLLOWUP); ?></option>
                                        </select>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                    <label><?php echo e(__("Gender")); ?><span class="text--base">*</span></label>
                                    <?php
                                        $gender  = old("gender");
                                    ?>
                                    <select class="form--control" name="gender" value="<?php echo e(old('gender')); ?>">
                                        <option selected disabled><?php echo e(__("Select Gender")); ?></option>
                                        <option value="<?php echo e(global_const()::GENDER_MALE); ?>" <?php if($gender == global_const()::GENDER_MALE ): ?> selected <?php endif; ?>><?php echo e(global_const()::GENDER_MALE); ?></option>
                                        <option value="<?php echo e(global_const()::GENDER_FEMALE); ?>" <?php if($gender == global_const()::GENDER_FEMALE ): ?> selected <?php endif; ?>><?php echo e(global_const()::GENDER_FEMALE); ?></option>
                                        <option value="<?php echo e(global_const()::GENDER_OTHER); ?>" <?php if($gender == global_const()::GENDER_OTHER ): ?> selected <?php endif; ?>><?php echo e(global_const()::GENDER_OTHER); ?></option>
                                    </select>
                                </div>
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <?php echo $__env->make('admin.components.form.textarea',[
                                        'label'         => __("Message").'<span class="text--warning">'.'('.__("Optional").')'.'</span>',
                                        'name'          => 'message',
                                        'value'         => old('message'),
                                        'placeholder'   => __("Write Here")."...",
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>    
                                </div>
                                <div class="col-lg-12 form-group">
                                    <button type="submit" class="btn--base small w-100"><?php echo e(__("Proceed")); ?><i class="fas fa-chevron-circle-right ms-1"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>  
                <?php endif; ?>
                
            </div>
        </form>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Booking section  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/pages/appointment-booking.blade.php ENDPATH**/ ?>