<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start about section
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<?php
    $app_local = get_default_language_code();
?>
<section class="about-section pb-120 <?php echo e($class ?? ""); ?>">
    <div class="container">
        <div class="row mb-30-none align-items-center">
            <div class="col-xl-6 col-lg-6 col-md-12 mb-30">
                <div class="about-content-wrapper">
                    <div class="about-content-area">
                        <div class="section-header">
                            <span class="section-sub-titel"><i class="fas fa-briefcase-medical"></i> <?php echo e($about->value->language->$app_local->title ?? ""); ?></span>
                            <h2 class="section-title"><?php echo e($about->value->language->$app_local->heading ?? ""); ?></h2>
                            <p><?php echo e($about->value->language->$app_local->sub_heading ?? ""); ?></p>
                        </div>
                    </div>
                    <div class="about-feature-area">
                        <ul class="feature-list">
                            <?php if(isset($about->value->items)): ?>
                                <?php $__currentLoopData = $about->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e(__( $item->language->$app_local->title ?? "")); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="feature-statistics-wrapper">
                        <div class="row mb-30-none">
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 mb-30">
                                <div class="statistics-item">
                                    <div class="statistics-content">
                                        <div class="odo-area">
                                            <?php
                                                $about_statistic = numeric_unit_converter($about->value->language->$app_local->statistic_first_value ?? "");
                                            ?>
                                            <h3 class="odo-title odometer" data-odometer-final="<?php echo e($about_statistic->number); ?>">0</h3>
                                            <h3 class="title"><?php echo e($about_statistic->unit); ?></h3>
                                        </div>
                                        <p><?php echo e($about->value->language->$app_local->statistic_first_title ?? ""); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 mb-30">
                                <div class="statistics-item">
                                    <div class="statistics-content">
                                        <div class="odo-area">
                                            <?php
                                                $about_statistic = numeric_unit_converter($about->value->language->$app_local->statistic_second_value ?? "");
                                            ?>
                                            <h3 class="odo-title odometer" data-odometer-final="<?php echo e($about_statistic->number); ?>">0</h3>
                                            <h3 class="title"><?php echo e($about_statistic->unit); ?></h3>
                                        </div>
                                        <p><?php echo e($about->value->language->$app_local->statistic_second_title ?? ""); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 mb-30">
                                <div class="statistics-item border-0">
                                    <div class="statistics-content">
                                        <div class="odo-area">
                                            <?php
                                                $about_statistic = numeric_unit_converter($about->value->language->$app_local->statistic_last_value ?? "");
                                            ?>
                                            <h3 class="odo-title odometer" data-odometer-final="<?php echo e($about_statistic->number); ?>">0</h3>
                                            <h3 class="title"><?php echo e($about_statistic->unit); ?></h3>
                                        </div>
                                        <p><?php echo e($about->value->language->$app_local->statistic_last_title ?? ""); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6 col-md-12 mb-30">
                <div class="about-thumb text-md-center">
                    <img src="<?php echo e(get_image($about->value->images->image ?? null,'site-section') ?? ''); ?>" alt="about">
                    <a class="video-icon" data-rel="lightcase:myCollection" href="<?php echo e($about->value->language->$app_local->video_link ?? ''); ?>">
                        <i class="las la-play"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End about section
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--><?php /**PATH D:\xampp\htdocs\adoctor-update_version\resources\views/frontend/section/about.blade.php ENDPATH**/ ?>